#include "vkgallery.h"
#include "ui_vkgallery.h"

VKGallery::VKGallery(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::VKGallery)
{
    ui->setupUi(this);
    init();

    this->isFriendsUpdate = false;
    this->isAlbumsUpdate = false;
    this->isPhotosUpdate = false;

    this->sm = new ServiceMgr(this);

    //connect to signals from service manager
    connect(sm, SIGNAL(updateFriends(FriendList, bool)), this, SLOT(updateListFriends(FriendList, bool)));

    // check that one acount mast be setup
    if (this->sm->getAccounts().length() == 0) {
        UISettings *settings = new UISettings(this->sm, this);
        settings->setModal(true);
        settings->addNewAccount();
    } else
        this->updateListFriends(sm->getFriends(false, true), true);

    connect(sm, SIGNAL(updateAlbumList(QString,AlbumList, bool)), this, SLOT(updateListAlbums(QString,AlbumList, bool)));
    connect(sm, SIGNAL(updatePhotoList(QString,PhotoList, bool)), this, SLOT(updateListPhotos(QString,PhotoList, bool)));
    connect(sm, SIGNAL(updateAccounts(AccountList)), this, SLOT(updateListAccounts(AccountList)));
    connect(sm, SIGNAL(errorOccured(QString, VkTransport::Action)), this, SLOT(gotErrorMsg(QString, VkTransport::Action)));

    this->on_pushButtonMe_toggled(true);
}

VKGallery::~VKGallery()
{
    delete ui;
    delete sm;
}

void VKGallery::init()
{
    //user
    //ui->pushButtonLogout->setIcon(QIcon::fromTheme("general_settings"));
    //ui->pushButtonLogout->setFlat(TRUE);
    ui->pushButtonMe->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));
    ui->pushButtonMe->setStyleSheet("text-align: left; image-position: left;");



    //friends list
    //label
    QIcon icon;
    icon = QIcon::fromTheme("general_contacts", QIcon(":/res/general_contacts.png"));
    lablContacts.setPixmap(icon.pixmap(48, QIcon::Normal, QIcon::On));
    lablContacts.setAlignment(Qt::AlignCenter);
    //ui->horizontalLayout_3->addWidget(lablContacts, NULL, NULL);
    //ui->horizontalLayout_3->addWidget(new QLabel("My Friends:"), NULL, NULL);
    ui->horizontalLayout_4->addWidget(buttonRefreshFriends = new QPushButton(this));
    //ui->horizontalLayout_3->setStretch(0, 0);
    //ui->horizontalLayout_3->setStretch(1, 1);
    //ui->horizontalLayout_3->setStretch(2, 0);
    buttonRefreshFriends->setFlat(TRUE);
    buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));

//    pi = new QProgressIndicator();
//    ui->horizontalLayout_4->insertWidget(1, pi, 0, Qt::AlignBottom);
//    ui->horizontalLayout_4->setStretch(2, 0);
//    pi->setVisible(FALSE);
    ui->listFriendsWidget->setStyleSheet("text-align: left; image-position: center;");

    //ui->pushButtonBack->setVisible(FALSE);
    //ui->pushButtonBack->setIcon(QIcon::fromTheme("general_back"));
   // ui->pushButtonBack->setFlat(TRUE);

    //listFriends();

#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    this->fullScreenButton = new FullScreenExitButton(this);
    this->fullScreenButton->hide();
#endif

    //filter
    ui->horizontalLayout_2->addWidget(editOwnr = new HintEdit(this));
    ui->horizontalLayout_2->addWidget(buttonEditOwnr = new QPushButton(this));

    buttonEditOwnr->setIcon(QIcon::fromTheme("general_backspace", QIcon(":/res/general_backspace.png")));
    buttonEditOwnr->setFlat(TRUE);
    editOwnr->setHintText("Type a name...");

    //albums
    icon = QIcon::fromTheme("tasklaunch_photos", QIcon(":/res/tasklaunch_photos.png"));
    ui->label_2->setPixmap(icon.pixmap(48, QIcon::Normal, QIcon::On));

    ui->horizontalLayout_5->addWidget(buttonRefreshAlbums = new QPushButton(this));
    buttonRefreshAlbums->setFlat(TRUE);
    buttonRefreshAlbums->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));

    //ui->listAlbums->setItemDelegate(new item(ui->listAlbums));

    //ui->horizontalLayout_5->insertWidget(0, buttonCloseAlbums = new QPushButton(this));
    //buttonCloseAlbums->setFlat(TRUE);
    //buttonCloseAlbums->setIcon(QIcon::fromTheme("general_back", QIcon(":/res/general_back.png")));

    hideAll(ui->verticalLayout_2);

    //photos
    icon = QIcon::fromTheme("general_image", QIcon(":/res/general_image.png"));
    ui->labelPhoto->setPixmap(icon.pixmap(64, QIcon::Normal, QIcon::On));
    ui->layoutPhotosLabel->addWidget(buttonRefreshPhotos = new QPushButton(this));
    buttonRefreshPhotos->setFlat(TRUE);
    buttonRefreshPhotos->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));

    ui->layoutPhotosLabel->insertWidget(0, buttonClosePhotos = new QPushButton(this));
    buttonClosePhotos->setFlat(TRUE);
    buttonClosePhotos->setIcon(QIcon::fromTheme("general_back", QIcon(":/res/general_back.png")));

    ui->listPhotosWidget->setDragDropMode(QAbstractItemView::NoDragDrop);

    hideAll(ui->layoutPhotos);

    //signals
    connect(editOwnr, SIGNAL(textChanged(QString)), this, SLOT(on_editOwnr_textChanged(QString)));
    connect(buttonEditOwnr, SIGNAL(clicked()), this, SLOT(on_buttonResetOwnr_clicked()));
    connect(ui->listFriendsWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(ownrSelected(QListWidgetItem*)));
    connect(ui->listFriendsWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(ownrSelected(QListWidgetItem*)));
    connect(ui->listAlbums, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(albmSelected(QListWidgetItem*)));
    connect(ui->listPhotosWidget, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(photoSelected(QListWidgetItem*)));
    connect(buttonRefreshFriends, SIGNAL(clicked()), this, SLOT(refreshFriends()));
    connect(buttonRefreshAlbums, SIGNAL(clicked()), this, SLOT(refreshAlbums()));
    connect(buttonRefreshPhotos, SIGNAL(clicked()), this, SLOT(refreshPhotos()));
    connect(buttonClosePhotos, SIGNAL(clicked()), this, SLOT(hidePhotos()));
    //connect(buttonCloseAlbums, SIGNAL(clicked()), this, SLOT(hideAlbums()));
    connect(ui->actionSettings, SIGNAL(triggered()), this, SLOT(on_actionSettings_toggled()));
    connect(ui->actionFull_screen, SIGNAL(triggered()), this, SLOT(on_actionFull_screen_toggled()));

    // enable sorting
    this->ui->listAlbums->setSortingEnabled(true);
    this->ui->listFriendsWidget->setSortingEnabled(true);
}

void VKGallery::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
void VKGallery::updateListFriends(FriendList list, bool isLastUpdate)
{
    qDebug() << "Start update Friend list process. isLastUpdate=" << isLastUpdate;

    if (isLastUpdate) {
        this->isFriendsUpdate = false;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    } else {
        this->isFriendsUpdate = true;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
    }

    if (list.isEmpty())
    {
        this->ui->listFriendsWidget->clear();
        if (isLastUpdate)
        {
            new QListWidgetItem("No Friends", this->ui->listFriendsWidget);
        } else {
            new QListWidgetItem("Download friend list", this->ui->listFriendsWidget);
        }
        return;
    }

    FriendList newFriends(list);
    QList<QListWidgetItem *> dels;

    // check that all current friends is contains in new list
    for (int i = 0; i < ui->listFriendsWidget->count(); i++) {
        bool isFound = false;

        QListWidgetItem *item = ui->listFriendsWidget->item(i);

        QVariant v = item->data(Qt::UserRole);
        Friend oldFd = v.value<Friend>();

        //qDebug() << "Try to find friend with id " << oldFd.id << " from " << oldFd.accountId;
        int removedVal = -1;

        for (int j = 0; j < newFriends.length(); j++) {
            Friend curFd = newFriends.at(j);
            if (oldFd.id == curFd.id &&
                oldFd.accountId == curFd.accountId) {
                removedVal = j;
                QImage *img = new QImage(curFd.icon);
                if (img->height() > img->width())
                    *img = img->copy(0, (img->height() - img->width()) / 2, img->width(), img->width());
                //item->setIcon(QIcon(curFd.icon));
                item->setIcon(QIcon(QPixmap::fromImage(*img)));
                if (item->icon().isNull())
                    item->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));
                v.setValue(curFd);
                item->setData(Qt::UserRole, v);

                isFound = true;
                break;
            }
        }

        if (isFound && removedVal >= 0) {
            newFriends.removeAt(removedVal);
            //qDebug() << "found friend " << fd.id << "newFriends length: " << newFriends.length() << " all friends length " << list.length();
        } else {
            qDebug() << "prepare to remove friend with id " << oldFd.id << " from " << oldFd.accountId;
        }


        if (!isFound)
            dels.append(item);
    }

    qDebug() << "Will be add " << newFriends.length() << " friends and removed " << dels.length() << " records. Total widgets: " << ui->listFriendsWidget->count();

    // add new Friends
    for (int i = 0; i < newFriends.length(); i++)
    {
        qDebug() << "added new Friend with id " << newFriends.at(i).id << " from " << newFriends.at(i).accountId;
        QListWidgetItem *item = new QListWidgetItem(Utils::decodeString(newFriends.at(i).name), ui->listFriendsWidget);
        QImage *img = new QImage(newFriends.at(i).icon);
        if (img->height() > img->width())
            *img = img->copy(0, (img->height() - img->width()) / 2, img->width(), img->width());
        item->setIcon(QIcon(newFriends.at(i).icon));
        //item->setIcon(QIcon(newFriends.at(i).icon));
        if (item->icon().isNull())
            item->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));
        QVariant v;
        v.setValue(newFriends.at(i));
        item->setData(Qt::UserRole, v);
    }

    // del old friends
    for (int i = 0; i < dels.length(); i++) {
        if (dels.at(i)->isSelected())
            this->on_pushButtonMe_toggled(true);
        delete dels.at(i);
    }

//    for (int i = 0; i < ui->horizontalLayout_2->count(); i++)
//    {
//        ui->horizontalLayout_2->itemAt(i)->widget()->setVisible(TRUE);
//    }

    // update album header for friend
    if (this->ui->listFriendsWidget->selectedItems().length() > 0)
    {
        QVariant v = this->ui->listFriendsWidget->selectedItems().at(0)->data(Qt::UserRole);
        Friend fd = v.value<Friend>();
        this->setAlbumHeader(fd);
    }
}



void VKGallery::refreshFriends()
{
    this->refreshFriends(true);
}

void VKGallery::refreshFriends(bool isNeedUpdate)
{
    if (!this->isFriendsUpdate)
    {
        on_buttonResetOwnr_clicked();
        this->isFriendsUpdate = true;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
        sm->getFriends(isNeedUpdate, true);
    }else {
        //TODO: add stopping friends update
    }
}

void VKGallery::refreshAlbums()
{
    this->refreshAlbums(true);
}

void VKGallery::refreshAlbums(bool isNeedUpdate)
{
    if (!this->isAlbumsUpdate)
    {
        this->isAlbumsUpdate = true;
        buttonRefreshAlbums->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
        if (this->ui->listFriendsWidget->selectedItems().length() > 0)
        {
            QListWidgetItem *item = this->ui->listFriendsWidget->currentItem();
            qDebug() << "Update albums for " << item->text();
            QVariant v = item->data(Qt::UserRole);
            if (v.canConvert<Friend>()) {
                Friend fd = v.value<Friend>();
                qDebug() << "Get albums for " << fd.id;
                this->sm->getAlbums(fd, isNeedUpdate, true);
            }
        }else{
            qDebug("Try to load my albums");
            this->sm->getMyAlbums(isNeedUpdate, true);
        }
    } else {
        //TODO: add stopping albums update
    }
}

void VKGallery::refreshPhotos()
{
    this->refreshPhotos(true);
}

void VKGallery::refreshPhotos(bool isNeedUpdate)
{
    QListWidgetItem *item = this->ui->listAlbums->currentItem();
    if (item == NULL)
    {
        qWarning() << "unknown selected item";
        return;
    }

    if (!this->isPhotosUpdate)
    {
        this->isPhotosUpdate = true;
        buttonRefreshPhotos->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
        qDebug() << "Update photos for " << item->text();
        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Album>()) {
            Album fd = v.value<Album>();
            qDebug() << "Get photos for " << fd.albumId;
            this->sm->getPhotos(fd, isNeedUpdate, true);
        }

    }
}

void VKGallery::on_buttonResetOwnr_clicked()
{
    editOwnr->clear();
}

void VKGallery::on_editOwnr_textChanged(QString str)
{
    int num = ui->listFriendsWidget->count();
    if (str.count() > 0)
    {
        for (int i = 0; i < num; i++)
            if (ui->listFriendsWidget->item(i)->text().indexOf(str, 0, Qt::CaseInsensitive) < 0)
                ui->listFriendsWidget->item(i)->setHidden(TRUE);
            else
                ui->listFriendsWidget->item(i)->setHidden(FALSE);
    } else {
        for (int i = 0; i < num; i++)
            ui->listFriendsWidget->item(i)->setHidden(FALSE);
    }
    ui->listFriendsWidget->scrollTo(ui->listFriendsWidget->currentIndex());
}

void VKGallery::ownrSelected(QListWidgetItem *item)
{
    ui->pushButtonMe->setChecked(FALSE);

    qDebug() << item->text();
    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Friend>()) {
        Friend fd = v.value<Friend>();
        qDebug() << "Get albums for " << fd.id;
        this->sm->getAlbums(fd, false, true);
        this->setAlbumHeader(fd);

        // shows album panels
        showAll(ui->horizontalLayout_5);
        ui->listAlbums->setVisible(TRUE);
    }else{
        this->setAlbumHeader();
    }
}

void VKGallery::albmSelected(QListWidgetItem *item)
{
    hideAll(ui->verticalLayout);
    qDebug() << "Selected album name: " << item->text();
    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Album>()) {
        Album fd = v.value<Album>();
        qDebug() << "Get photos for " << fd.albumId;
        this->sm->getPhotos(fd, false, true);
        this->setPhotoHeader(fd);
        showAll(ui->layoutPhotos);
        ui->listPhotosWidget->setVisible(true);
    }else{
        this->setPhotoHeader();
    }
}

void VKGallery::setAlbumHeader()
{
    ui->label->setText("Album(s):");
    ui->label_2->setPixmap(QIcon::fromTheme("tasklaunch_photos", QIcon(":/res/tasklaunch_photos.png")).pixmap(48, QIcon::Normal, QIcon::On));
}

void VKGallery::setAlbumHeader(Friend fd)
{
    ui->label->setText(Utils::decodeString(fd.name) + "\nAlbum(s):");
    QIcon friendIcon = QIcon(fd.icon);
    if (!friendIcon.isNull())
        ui->label_2->setPixmap(friendIcon.pixmap(48, QIcon::Normal, QIcon::On));
}

void VKGallery::setPhotoHeader()
{
    QIcon icon = QIcon::fromTheme("general_image", QIcon(":/res/general_image.png"));
    ui->labelPhoto->setPixmap(icon.pixmap(64, QIcon::Normal, QIcon::On));
    ui->label_3->setText("Photo(s):");
}

void VKGallery::setPhotoHeader(Album al)
{
    QString phts = al.size > 1 ? " photos:" : " photo:";
    ui->label_3->setText(Utils::decodeString(al.title) +
                         (al.description.isNull() ? "": "\n" +
                          Utils::decodeString(al.description)) +
                         "\n" + QString::number(al.size) + phts);
    QPixmap *pm = new QPixmap(al.icon);
    *pm = pm->scaledToWidth(80, Qt::SmoothTransformation);
    QIcon albumIcon = QIcon(*pm);
    if (!albumIcon.isNull())
        ui->labelPhoto->setPixmap(albumIcon.pixmap(64, QIcon::Normal, QIcon::On));
}

void VKGallery::on_pushButtonMe_toggled(bool checked)
{
    if (this->ui->pushButtonMe->isChecked() != checked)
    {
        this->ui->pushButtonMe->setChecked(checked);
        return;
    }

    if(checked)
    {
        ui->listFriendsWidget->clearSelection();

        this->sm->getMyAlbums(false, true);

        // shows album panels
        showAll(ui->horizontalLayout_5);
        ui->listAlbums->setVisible(TRUE);

        AccountList accs = this->sm->getAccounts();
        for (int i = 0; i < accs.length(); i++)
        {
            Friend fr = accs.at(i)->getProfile(false);
            if (!fr.id.isEmpty())
            {
                this->setAlbumHeader(fr);
                break;
            }
        }
    }

}

QString VKGallery::albumItem(Album al)
{
    QString phts = al.size > 1 ? " photos" : " photo";
    QString str = Utils::decodeString(al.title) + "\n";
    str += QString::number(al.size) + phts + '.';
    if (al.size != 0)
        str += " Updated: " + al.time_update;
    str += '\n' + Utils::decodeString(al.description);

    return str;
}

QPixmap VKGallery::albumIcon(Album al)
{
    QPixmap pm(al.icon);
    if (pm.isNull())
    {
        QIcon icon = QIcon::fromTheme("tasklaunch_photos", QIcon(":/res/tasklaunch_photos.png"));
        pm = icon.pixmap(48, QIcon::Normal, QIcon::On);
    } else {
        pm = pm.scaledToWidth(80, Qt::SmoothTransformation);
    }
    return pm;
}

void VKGallery::updateListAlbums(QString owner, AlbumList list, bool isLastUpdate)
{
    bool isFoundSelectedFriend = false;
    if (owner.isEmpty()) {
        // it's my cached albums. passed.
        isFoundSelectedFriend = true;
    }
    else {
        if (this->ui->listFriendsWidget->selectedItems().length() > 0)
        {
            // check correctness that list was return for selected friend
            QList<QListWidgetItem *> selFriends = ui->listFriendsWidget->selectedItems();
            for (int i = 0; i < selFriends.length(); i++) {
                QVariant v = selFriends[i]->data(Qt::UserRole);
                if (v.canConvert<Friend>()) {
                    Friend fd = v.value<Friend>();
                    if (owner == fd.id) {
                        isFoundSelectedFriend = true;
                        break;
                    }
                }
            }
        }else{
            // it is my albums
            AccountList accs = this->sm->getAccounts();
            for (int i = 0; i < accs.length(); i++)
            {
                if (accs.at(i)->getProfile(false).id == owner)
                {
                    isFoundSelectedFriend = true;
                    break;
                }
            }
        }
    }

    if (!isFoundSelectedFriend)
        return;

    if (isLastUpdate) {
        this->isAlbumsUpdate = false;
        buttonRefreshAlbums->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    } else {
        this->isAlbumsUpdate = true;
        buttonRefreshAlbums->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
    }

    if (list.isEmpty()) {
        qDebug() << "Empty album list for " << owner << "!!!!!!";
        ui->listAlbums->clear();
        if (isLastUpdate)
            new QListWidgetItem("No albums", ui->listAlbums); //QListWidgetItem *item2 = new
        else
            new QListWidgetItem("Download albums", this->ui->listAlbums);
        ui->listAlbums->setDisabled(true);
        return;
    }

    ui->listAlbums->setDisabled(false);
//    ui->listAlbums->setItemDelegate(new item(ui->listAlbums));

    QList<QListWidgetItem *> delItems;
    AlbumList newAlbums;
    newAlbums.append(list);

    // search new albums in list of widgets
    for (int i = 0; i < this->ui->listAlbums->count(); i++)
    {
        QListWidgetItem *item = this->ui->listAlbums->item(i);
        QVariant v = item->data(Qt::UserRole);

        bool isFound = false;
        int removedVal = -1;

        if (v.canConvert<Album>())
        {
            Album oldAlbum = v.value<Album>();

            //qDebug() << "Try to find friend with id " << oldFd.id << " from " << oldFd.accountId;

            for (int j = 0; j < newAlbums.length(); j++) {
                Album curAlbum = newAlbums.at(j);
                if (oldAlbum.albumId == curAlbum.albumId &&
                    oldAlbum.accountId == curAlbum.accountId) {
                    removedVal = j;
                    item->setData(Qt::DecorationRole, this->albumIcon(curAlbum));

                    item->setData(Qt::DisplayRole, this->albumItem(curAlbum));

                    v.setValue(curAlbum);
                    item->setData(Qt::UserRole, v);

                    isFound = true;
                    break;
                }
            }

            if (isFound && removedVal >= 0) {
                newAlbums.removeAt(removedVal);
                //qDebug() << "found friend " << fd.id << "newFriends length: " << newFriends.length() << " all friends length " << list.length();
            } else {
                qDebug() << "prepare to remove album with id " << oldAlbum.albumId << " from " << oldAlbum.accountId;
            }
        }

        if (!isFound)
            delItems.append(item);
    }

    qDebug() << "Will be add " << newAlbums.length() << " albums and removed " << delItems.length() << " records. Total widgets: " << ui->listAlbums->count();

    // add new albums
    for (int i = 0; i < newAlbums.length(); i++) {
        //QListWidgetItem *item = new QListWidgetItem(str, ui->listAlbums);
        //item->setIcon(QIcon(list[i]->icon));
        //if (item->icon().isNull())
        //    item->setIcon(QPixmap(":/res/ms.png"));
        QListWidgetItem *albumitem = new QListWidgetItem(ui->listAlbums);
        albumitem->setData(Qt::DecorationRole, this->albumIcon(newAlbums.at(i)));

        albumitem->setData(Qt::DisplayRole, this->albumItem(newAlbums.at(i)));

        QVariant v;
        v.setValue(newAlbums[i]);
        albumitem->setData(Qt::UserRole, v);
    }

    // del old albums
    for (int i = 0; i < delItems.length(); i++) {
        if (delItems.at(i)->isSelected())
            this->hidePhotos();
        delete delItems.at(i);
    }

    // update photo header
    if (this->ui->listAlbums->selectedItems().length() > 0)
    {
        QVariant v = this->ui->listAlbums->selectedItems().at(0)->data(Qt::UserRole);
        Album al = v.value<Album>();
        this->setPhotoHeader(al);
    }
}

QPixmap VKGallery::photoIcon(Photo al)
{
    QPixmap pm(al.icon);
    if (pm.isNull())
    {
        QIcon icon = QIcon::fromTheme("general_image", QIcon(":/res/general_image.png"));
        pm = icon.pixmap(48, QIcon::Normal, QIcon::On);
    } else {
        pm = pm.scaledToWidth(100, Qt::SmoothTransformation);
    }
    return pm;
}

void VKGallery::updateListPhotos(QString albumId, PhotoList list, bool isLastUpdate)
{
    // check correctness that list was return for selected photo list
    bool isFoundSelectedAlbum = false;
    QList<QListWidgetItem *> selItems = ui->listAlbums->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Album>()) {
            Album fd = v.value<Album>();
            if (albumId == fd.albumId) {
                isFoundSelectedAlbum = true;
                break;
            }
        }
    }
    if (!isFoundSelectedAlbum)
        return;

    if (isLastUpdate) {
        this->isPhotosUpdate = false;
        buttonRefreshPhotos->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    } else {
        this->isPhotosUpdate = true;
        buttonRefreshPhotos->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
    }

    if (list.isEmpty()) {
        this->ui->listPhotosWidget->clear();
        if (isLastUpdate)
            new QListWidgetItem("No images", ui->listPhotosWidget); //QListWidgetItem *item2 = new
        else
            new QListWidgetItem("Download images", this->ui->listPhotosWidget);
        ui->listPhotosWidget->setDisabled(true);
        return;
    }

    //ui->listPhotosWidget->clear();
    ui->listPhotosWidget->setDisabled(false);


    QList<QListWidgetItem *> delItems;
    PhotoList newPhoto;
    newPhoto.append(list);

    // search new images in list of widgets
    for (int i = 0; i < this->ui->listPhotosWidget->count(); i++)
    {
        QListWidgetItem *item = this->ui->listPhotosWidget->item(i);
        QVariant v = item->data(Qt::UserRole);

        bool isFound = false;
        int removedVal = -1;

        if (v.canConvert<Photo>())
        {
            Photo oldPhoto = v.value<Photo>();

            //qDebug() << "Try to find friend with id " << oldFd.id << " from " << oldFd.accountId;

            for (int j = 0; j < newPhoto.length(); j++) {
                Photo curPhoto = newPhoto.at(j);
                if (oldPhoto.photoId == curPhoto.photoId &&
                    oldPhoto.accountId == curPhoto.accountId) {
                    removedVal = j;

                    QPixmap icon = this->photoIcon(curPhoto);
                    item->setData(Qt::DecorationRole, icon);
                    ((QAbstractItemView*)this->ui->listPhotosWidget)->setIconSize(icon.size());

                    v.setValue(curPhoto);
                    item->setData(Qt::UserRole, v);

                    isFound = true;
                    break;
                }
            }

            if (isFound && removedVal >= 0) {
                newPhoto.removeAt(removedVal);
                //qDebug() << "found friend " << fd.id << "newFriends length: " << newFriends.length() << " all friends length " << list.length();
            } else {
                qDebug() << "prepare to remove photo with id " << oldPhoto.photoId << " from " << oldPhoto.accountId;
            }
        }

        if (!isFound)
            delItems.append(item);
    }
    this->ui->listPhotosWidget->setUpdatesEnabled(false);
    // add new photos
    for (int i = 0; i < newPhoto.length(); i++) {
        qDebug() << "Show photo_thumb: " << newPhoto.at(i).photoId;
        QListWidgetItem *item = new QListWidgetItem(NULL, ui->listPhotosWidget);
        QPixmap icon = this->photoIcon(newPhoto.at(i));
        item->setData(Qt::DecorationRole, icon);
        ((QAbstractItemView*)this->ui->listPhotosWidget)->setIconSize(icon.size());
        QVariant v;
        v.setValue(newPhoto.at(i));
        item->setData(Qt::UserRole, v);
    }

    // del old photos
    for (int i = 0; i < delItems.length(); i++) {
        delete delItems.at(i);
    }

    this->ui->listPhotosWidget->setUpdatesEnabled(true);
    this->ui->listPhotosWidget->repaint();
}

void VKGallery::on_pushButtonLogout_clicked()
{
}

void VKGallery::on_actionFull_screen_toggled()
{
    bool isFullScreen = windowState() & Qt::WindowFullScreen;
    if (isFullScreen) {
#ifdef Q_WS_MAEMO_5
        fullScreenButton->hide();
#endif
        showNormal();
    } else {
        showFullScreen();
#ifdef Q_WS_MAEMO_5
        fullScreenButton->show();
#endif
    }
}

void VKGallery::on_actionSettings_toggled()
{
    UISettings *settings = new UISettings(this->sm, this);
    settings->setModal(true);
    settings->show();
}

void VKGallery::hidePhotos()
{
    hideAll(ui->layoutPhotos);
    //ui->pushButtonBack->setVisible(TRUE);
    showAll(ui->verticalLayout);
}
void VKGallery::hideAlbums()
{
    hidePhotos();
    hideAll(ui->verticalLayout_2);
}

void VKGallery::hideAll(QLayout *layout)
{
    for (int i = 0; i < layout->count(); i++)
    {
        if(layout->itemAt(i)->layout())
        {
            hideAll(layout->itemAt(i)->layout());
        } else {
            layout->itemAt(i)->widget()->setVisible(FALSE);
        }
    }
}
void VKGallery::showAll(QLayout *layout)
{
    for (int i = 0; i < layout->count(); i++)
    {
        if(layout->itemAt(i)->layout())
        {
            showAll(layout->itemAt(i)->layout());
        } else {
            layout->itemAt(i)->widget()->setVisible(TRUE);
        }
    }
}

void VKGallery::photoSelected(QListWidgetItem *item) {
    QImageViewer *viewer = new QImageViewer(this);

    connect(this->sm, SIGNAL(updatePhoto(QString,QString,QString,PhotoList,bool)), viewer, SLOT(imageListUpdate(QString,QString,QString,PhotoList,bool)));
#ifdef Q_WS_MAEMO_5
    viewer->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Photo>()) {
        Photo fd = v.value<Photo>();
        viewer->loadImage(sm, fd);
    }
}

void VKGallery::gotErrorMsg(QString errorMsg, VkTransport::Action acc) {
    QMessageBox::warning(this, tr("Error occured"),
                             errorMsg);
    if (acc == VkTransport::updateListFriendsAction)
    {
        this->isFriendsUpdate = false;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    }
    if (acc == VkTransport::getAlbumsAction)
    {
        this->isAlbumsUpdate = false;
        buttonRefreshAlbums->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    }
    if (acc == VkTransport::getPhotosAction)
    {
        this->isPhotosUpdate = false;
        buttonRefreshPhotos->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    }
}

void VKGallery::updateListAccounts(AccountList) {
    this->refreshFriends(false);
    this->refreshAlbums(false);
    this->refreshPhotos(false);
}
