#include "qimageviewer.h"

QImageViewer::QImageViewer(QWidget *parent) :
    QMainWindow(parent)
{
    QFont f("Helvetica",12);

    scene = new QGraphicsScene(this);
    view = new QMouseTrackingView(scene, this);
    setCentralWidget(view);
    view->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    view->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    pixmapItem = new QGraphicsPixmapItem();
    pixmapItem->setZValue(1);
    pixmapItem->setCacheMode(QGraphicsPixmapItem::DeviceCoordinateCache);
    scene->addItem(pixmapItem);

    processItem = new QGraphicsTextItem();
    //processItem->setDefaultTextColor(Qt::white);
    processItem->setFont(f);
    processItem->setZValue(0);
    scene->addItem(processItem);

    windowSize = this->centralWidget()->size();
//    this->grabMouse();
//    this->setMouseTracking(true);

    connect(view, SIGNAL(mouseDragged(Qt::ArrowType)), this, SLOT(moveImage(Qt::ArrowType)));
    connect(view, SIGNAL(mouseDoubleClick()), this, SLOT(on_actionFull_screen_toggled()));

#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    this->fullScreenButton = new FullScreenExitButton(this);
    this->fullScreenButton->hide();

    /* create osso context in your app that is passed to sharing */
    osso = osso_initialize ("mysocials-gallery", "1.0.0.", FALSE, NULL);
    //QLibrary lib("libsharingdialog.so", this);
#endif
}

QImageViewer::~QImageViewer()
{
#ifdef Q_WS_MAEMO_5
     osso_deinitialize(osso);
#endif
    this->releaseMouse();
    delete pixmapItem;
    delete processItem;
    delete view;
    delete scene;
}

void QImageViewer::loadImage(ServiceMgr *sm, Photo image) {
    this->sm = sm;
    this->currentPhoto = image;
    this->currentImageIndex = -1;


//    imagelbl = new QLabel;
//    imagelbl->setBackgroundRole(QPalette::Base);
//    imagelbl->setSizePolicy(QSizePolicy::Ignored, QSizePolicy::Ignored);
//    imagelbl->setScaledContents(true);
//    setCentralWidget(imagelbl);

    setWindowTitle(tr(WINDOW_TITLE));
    this->showMaximized();

    this->list = this->sm->getPhotosForAlbum(this->currentPhoto);
    for (int i = 0; i < this->list.length(); i++)
    {
        if (list.at(i).photoId == this->currentPhoto.photoId)
        {
            this->currentImageIndex = i;
            break;
        }
    }

    this->sm->downloadPhotos(image, 1);
    this->showImage(false);
}

void QImageViewer::imageListUpdate(QString accountId, QString friendId, QString albumId, PhotoList list, bool)
{
    qDebug() << "got new images for album " << albumId;
    if (this->currentPhoto.accountId == accountId &&
        this->currentPhoto.ownerId == friendId &&
        this->currentPhoto.albumId == albumId)
        this->list = list;
    else
        return;

    this->showImage(true);
}

void QImageViewer::showImage(bool isNeedCompare)
{
    if (this->currentImageIndex >= 0 && this->currentImageIndex < this->list.length())
    {
        this->setWindowTitle(tr(WINDOW_TITLE) + tr(" (") +
                             QString::number(this->currentImageIndex + 1) + tr("/") +
                             QString::number(this->list.length()) + tr(")"));
    } else {
        return;
    }
    Photo img = this->list.at(this->currentImageIndex);

    qDebug() << "Try to show image " << img.photoId << " from " << img.photo;

    bool isNeedUpdate = false;
    if (isNeedCompare)
    {
        if (this->currentPhoto.photoId == img.photoId &&
            this->currentPhoto.photo == img.photo &&
            this->currentPhoto.icon == img.icon)
            isNeedUpdate = false;
        else
            isNeedUpdate = true;
    }else{
        isNeedUpdate = true;
    }

    qDebug() << "isNeedUpdate=" << isNeedUpdate << " isNeedCompare=" << isNeedCompare;

    QSize imageSize;
    if (isNeedUpdate)
    {
        //try to open image from file
        if (!img.photo.isEmpty())
        {
            processItem->hide();
            pixmapItem->show();
            QImage image(img.photo);
            if (image.isNull()) {
                QMessageBox::information(this, tr("Image Viewer"),
                                         tr("Cannot load %1.").arg(img.photo));
            } else {
                // Set/scale image size into screen
                imageSize = image.size();
                if (imageSize.height() > windowSize.height() ||
                    imageSize.width() > windowSize.width())
                {
                    imageSize.scale(windowSize, Qt::KeepAspectRatio);
                    image = image.scaled(imageSize);

                }
                // Make QPixmap
                QPixmap p = QPixmap::fromImage(image);
                this->pixmapItem->setPixmap(p);
#ifdef Q_WS_MAEMO_5
                //            sharing_dialog_with_file (osso,
                //                                      NULL,
                //                                      img.photo);
#endif
            }
        }else{
            // show image preview
            QImage image(img.icon);
            if (image.isNull())
            {
                pixmapItem->hide();
            } else {
                this->pixmapItem->setPixmap(QPixmap::fromImage(image));
                imageSize = image.size();
            }
            this->sm->downloadPhotos(this->list.at(this->currentImageIndex), 0);

            processItem->show();
            processItem->setPlainText("Downloading image...");
        }
    }

    // set image position
    if (pixmapItem->isVisible())
    {
        QPoint center;
        center.setX((windowSize.width() - imageSize.width()) / 2);
        center.setY((windowSize.height() - imageSize.height()) / 2);
        pixmapItem->setPos(center);
        qDebug() << "Image size: " << imageSize << " windowSize: " << windowSize << " ImagePos: " << center;
    }

    // set message position
    if (processItem->isVisible())
    {
        QFontMetrics fm(processItem->font());

        QPoint textCenter;
        textCenter.setX((windowSize.width() - processItem->boundingRect().width()) / 2);
        textCenter.setY((windowSize.height() - imageSize.height()) / 2 - fm.height() * 2);
        processItem->setPos(textCenter);
    }
}

void QImageViewer::close()
{
    QMainWindow::close();
    this->destroy();
}

void QImageViewer::resizeEvent(QResizeEvent * event)
{
    QMainWindow::resizeEvent(event);
    windowSize = this->size();
    // Update scene and view sizes
    scene->setSceneRect(view->rect());

    this->showImage(true);
}

void QImageViewer::moveImage(Qt::ArrowType direction)
{
    if (this->list.isEmpty())
        return;


    if (direction == Qt::LeftArrow)
    {
        this->currentImageIndex--;
        if (this->currentImageIndex < 0)
            this->currentImageIndex = this->list.length() - 1;
    }
    if (direction == Qt::RightArrow)
    {
        this->currentImageIndex++;
        if (this->currentImageIndex >= this->list.length())
            this->currentImageIndex = 0;
    }
    this->view->reset();
    this->showImage(true);
    this->sm->downloadPhotos(this->list.at(this->currentImageIndex), 1);
}

void QImageViewer::on_actionFull_screen_toggled()
{
    bool isFullScreen = windowState() & Qt::WindowFullScreen;
    if (isFullScreen) {
#ifdef Q_WS_MAEMO_5
        fullScreenButton->hide();
#endif
        showMaximized();
    } else {
        showFullScreen();
#ifdef Q_WS_MAEMO_5
        fullScreenButton->show();
#endif
    }
}
