#include "hintedit.h"
#include "qpainter.h"

HintEdit::HintEdit(QWidget *parent)
: QLineEdit (parent)
{
    enterFlag = false;
    hintText = "Type...";
}

void HintEdit::focusInEvent(QFocusEvent *event)
{
   if (!enterFlag)
   {
       emit onEnterEvent();
       enterFlag = true;
   }
}

void HintEdit::focusOutEvent(QFocusEvent *event)
{
    if (enterFlag)
	{
        emit onLeaveEvent();
        enterFlag = false;
    }
}

void HintEdit::paintEvent(QPaintEvent *event)
{
    if (text().isEmpty() && !hasFocus())
    {
        QLineEdit::paintEvent(event);
        QPainter painter(this);
        painter.setPen(Qt::gray);
        painter.drawText(rect(), Qt::AlignCenter, hintText);
    } else
        QLineEdit::paintEvent(event);
}

void HintEdit::setHintText(QString str)
{
    this->hintText = str;
}
