#ifndef QREFRESHLIST_H
#define QREFRESHLIST_H

#include <QObject>
#include <QList>
#include <QDate>

/**
  \brief Extends QList with fixation time creation.
  */
template <class T> class QRefreshList : public QList<T>
{
private:
    QDateTime _timeCreate;

public:
    /**
      \brief Default constructor.
      */
    QRefreshList() {}

    /**
      \brief Destructor.
      */
    ~QRefreshList() {}

    /**
      \brief Get list time creation.

      \return List creation time.
      */
    QDateTime timeCreate() const {return this->_timeCreate;}

    /**
      \brief Sets list time creation.

      \param val New value of time creation.
      */
    void setTimeCreate(const QDateTime& val) {this->_timeCreate = val;}

signals:

public slots:

};

#endif // QREFRESHLIST_H
