#ifndef SERVICEFILTER_H
#define SERVICEFILTER_H

#include <QObject>
#include <QVariant>
#include <QSet>
#include <QList>

#include "servicemgr.h"

class ServiceMgr;
class ServiceFilterWidget;
class DriverInfo;
class QWidget;
class QToolBar;
class QActionGroup;

class ServiceFilter : public QObject
{
    Q_OBJECT
    ServiceMgr* mServiceManager; //!< Service manager

    mutable QSet<QString> mCacheServiceNames; //!< Names of active services
    bool mSplit; //!< Each panel has own state of filter
    bool mDisableEventHandling; //!< Disable receiving signals from panels
                                //!< Possibly unnessessary

    bool isServiceActive(const DriverInfo* driver) const;

public:
    explicit ServiceFilter(ServiceMgr* mgr, bool split, QObject *parent = 0);

    void registerFilterInterface(QObject* interface);
    void fillPanel();

signals:
    void serviceSelected(DriverInfo* driverInfo);
    void itemAdded(const QIcon& icon, DriverInfo* driver, bool checked = 0);
    void itemAdded(const QString& string, DriverInfo* driver, bool checked = 0);
    void checkItem(int index);
    void reset();

public slots:
    void updateAccounts(QString str, AccountList accountList);
    void selectService(DriverInfo* driverInfo, int index = -1);
};

#endif // SERVICEFILTER_H
