#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->sm = new ServiceMgr(this);
    ImageBrowserPanel *panel = new ImageBrowserPanel(sm, this);
    this->setCentralWidget(panel);

    // connect to image browser panel signals
    connect(panel, SIGNAL(openImage(Photo)), this, SLOT(openImage(Photo)));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::openImage(Photo photo)
{
    QImageViewer *viewer = new QImageViewer(this->font(), this);

#ifdef Q_WS_MAEMO_5
    viewer->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    viewer->loadImage(this->sm, photo);
}
