#include "uihelp.h"
#include "ui_uihelp.h"

uihelp::uihelp(QString path, QString title, QFont fnt, QWidget *parent):
    QMainWindow(parent),
    ui(new Ui::uihelp)
{
    ui->setupUi(this);
    this->setWindowTitle(title);
    this->ui->webView->setFont(fnt);

    qDebug() << "show file " << path;
    this->ui->webView->setUrl(QUrl("file:///" + path));
}

uihelp::~uihelp()
{
    delete ui;
}

void uihelp::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
