#ifndef UIADDACCOUNT_H
#define UIADDACCOUNT_H

#include <QDialog>

#include <servicemgr.h>
#include "datatypes/driverinfo.h"

namespace Ui {
    class UIAddAccount;
}

/**
  \brief Add account dialog.

  This class is using to show add account dialog. The list of supported services gets from Service Manager (see \a ServiceMgr).

  \sa ServiceMgr
  \sa UIAccountSettings
  \sa Account
  \sa DriverInfo
  */
class UIAddAccount : public QDialog
{
    Q_OBJECT

public:
    /**
      \brief Add account dialog constructor.

      \param sm Pointer to Service Manager.

      \param parent Pointer to parent widget.
      */
    explicit UIAddAccount(ServiceMgr *sm, QWidget *parent = 0);

    /**
      \brief Default destructor.
      */
    ~UIAddAccount();

private:
    Ui::UIAddAccount *ui;
    ServiceMgr *sm;

private slots:
    /**
     * @brief check data correctivity
     *
    */
    void verify();

};

#endif // UIADDACCOUNT_H
