#include "messagecomposer.h"
#include "ui_messagecomposer.h"

MessageComposer::MessageComposer(QWidget *parent) :
        QWidget(parent), ui(new Ui::MessageComposer)
{
    ui->setupUi(this);
    this->sm = new ServiceMgr;
    init();
}

MessageComposer::MessageComposer(ServiceMgr *sm, QWidget *parent) :
        QWidget(parent), ui(new Ui::MessageComposer)
{
    ui->setupUi(this);
    this->sm = sm;
    init();
}

MessageComposer::~MessageComposer()
{
    delete ui;
}

void MessageComposer::init()
{
    ui->layoutMessageComposerBottom->addWidget(buttonSend = new QPushButton(tr("Send")), 0);
    buttonSend->setFlat(TRUE);

    ui->layoutMessageComposerBottom->addWidget(buttonSave = new QPushButton(tr("Save")), 0);
    buttonSave->setFlat(TRUE);

    connect(buttonSend, SIGNAL(clicked()), this, SLOT(sendMessage()));
    connect(buttonSave, SIGNAL(clicked()), this, SLOT(saveMessage()));

    connect(this->sm, SIGNAL(updateAccounts(AccountList)), this,
            SLOT(updateAccounts(AccountList)));
    connect(this->sm, SIGNAL(updateFriends(FriendList,bool)), this,
            SLOT(updateFriendList(FriendList, bool)));
}

void MessageComposer::updateAccounts(AccountList list)
{
    QVariant v;
    this->ui->listFriends->clear();

    for (int i = 0; i < list.count(); i++) {
        foreach(Friend fd, list.at(i)->getFriendList()) {
            v.setValue(fd);

            QImage img = QImage(fd.icon());

            if (!img.isNull()) {
                if (img.height() > img.width())
                    img = img.copy(0, (img.height() - img.width()) / 2, img.width(), img.width());

                img = img.scaled(32, 32, Qt::KeepAspectRatio, Qt::SmoothTransformation);

                this->ui->listFriends->addItem(QIcon(QPixmap::fromImage(img)),
                        Utils::decodeString(fd.name()),v);
            } else {
                this->ui->listFriends->addItem(Utils::decodeString(fd.name()),v);
            }
        }
    }
}

void MessageComposer::updateFriendList(FriendList list, bool )
{
    ui->listFriends->clear();

    for (int i = 0; i < list.count(); i++) {
        QVariant v;
        Friend fd = list.at(i);

        v.setValue(fd);

        QImage img = QImage(fd.icon());

        if (!img.isNull()) {
            if (img.height() > img.width())
                img = img.copy(0, (img.height() - img.width()) / 2, img.width(), img.width());

            img = img.scaled(32, 32, Qt::KeepAspectRatio, Qt::SmoothTransformation);

            this->ui->listFriends->addItem(QIcon(QPixmap::fromImage(img)),
                    Utils::decodeString(fd.name()),v);
        } else {
            this->ui->listFriends->addItem(Utils::decodeString(fd.name()),v);
        }
    }
}

void MessageComposer::sendMessage()
{
    QString to;
    QString title = this->ui->titleLineEdit->text();
    QString message = this->ui->textBrowser->toPlainText();

    int index = ui->listFriends->currentIndex();
    QVariant v = ui->listFriends->itemData(index);

    if (v == QVariant::Invalid)
        return;

    if (v.canConvert<Friend>()) {
        Friend fd = v.value<Friend>();

        this->sm->sendMessage(fd.accountId, fd.ownerId, title, message);
    }

    emit sendMessage(to, title, message);
}

void MessageComposer::replyMessage(Message msg)
{
    for (int i = 0; i < ui->listFriends->count(); i++) {
        QVariant v = ui->listFriends->itemData(i);

        if (v.canConvert<Friend>()) {
            Friend item = v.value<Friend>();

            if (item.ownerId == msg.senderId)
                this->ui->listFriends->setCurrentIndex(i);
        }
    }

    this->ui->titleLineEdit->setText(QString(tr("Re: %1")).arg(msg.subject()));
    this->ui->textBrowser->setFocus();
}

void MessageComposer::saveMessage()
{
    Recepient rec;
    QString senderId;

    QVariant v = this->ui->listFriends->itemData(ui->listFriends->currentIndex());
    if (v.canConvert<Friend>()) {
        Friend fd = v.value<Friend>();

        rec.id = fd.ownerId;
        rec.name = fd.name();
        senderId = fd.accountId;
    }

    QString title = this->ui->titleLineEdit->text();
    QString message = this->ui->textBrowser->toPlainText();

    Message msg;
    msg.accountId = senderId;
    msg.title = title;
    msg.text = message;
    msg.recepientList.append(rec);
    msg.senderId = senderId;

    AccountList list = this->sm->getAccounts();    

    for (int i = 0; i < list.count(); i++) {
        if (list.at(i)->accountId() == senderId) {
            msg.senderName = list.at(i)->getProfile(false).name();

            MessageList list2 = list.at(i)->getDraftMessages();

            if (list2.count() > 0) {
                int id = list2.last().messageId.toInt() + 1;
                msg.messageId = QString::number(id);
            } else {
                msg.messageId = QString::number(0);
            }

            list2.append(msg);
            list.at(i)->setDraftMessages(list2);
        }
    }

    emit saveMessage(msg);
}

void MessageComposer::resetMessage()
{
    this->ui->titleLineEdit->clear();
    this->ui->textBrowser->clear();
}

void MessageComposer::setRecepient(Friend fd)
{
    this->setRecepient(fd.ownerId);
}

void MessageComposer::setRecepient(QString ownerId)
{
    for (int i = 0; i < ui->listFriends->count(); i++) {
        QVariant v = ui->listFriends->itemData(i);

        if (v.canConvert<Friend>()) {
            Friend item = v.value<Friend>();

            if (item.ownerId == ownerId)
                this->ui->listFriends->setCurrentIndex(i);
        }
    }
}

void MessageComposer::setTitle(QString title)
{
    this->ui->titleLineEdit->setText(title);
    this->ui->titleLineEdit->setCursorPosition(0);
}

void MessageComposer::setMessageBody(QString text)
{
    this->ui->textBrowser->setText(text);
}
