#include "messagebrowser.h"
#include "ui_messagebrowser.h"
#include <QDebug>

MessageBrowser::MessageBrowser(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::MessageBrowser)
{
    ui->setupUi(this);
    this->ui->messageBrowser->setMinimumHeight(50);
}

MessageBrowser::MessageBrowser(Message msg, QWidget *parent) :
        QWidget(parent),
        ui(new Ui::MessageBrowser)
{
    ui->setupUi(this);
    this->setMessage(msg);
    this->ui->messageBrowser->setMinimumHeight(50);
}

MessageBrowser::~MessageBrowser()
{
    delete ui;
}

QStringList MessageBrowser::to()
{
    QString recepients = ui->toLineEdit->text();
    QStringList list = recepients.split(QRegExp("\\s"));
    list.replaceInStrings(",","");

    return list;
}

QString MessageBrowser::from()
{
    return this->ui->fromLineEdit->text();
}

QString MessageBrowser::title()
{
    return this->ui->titleLineEdit->text();
}

QString MessageBrowser::message()
{
    return this->ui->messageBrowser->toPlainText();
}

void MessageBrowser::resetMessage()
{
    ui->toLineEdit->clear();
    ui->fromLineEdit->clear();
    ui->titleLineEdit->clear();
    ui->messageBrowser->clear();
    ui->dateLineEdit->clear();
}

void MessageBrowser::setMessage(Message msg)
{
    QString recepients;
    QString senderId = msg.senderId;

    if (msg.recepientList.count() >= 1) {
        for (int i = 0; i < msg.recepientList.count(); i++) {
            if (msg.recepientList.at(i).id != senderId) {
                if ((msg.recepientList.count() - i) == 1) {
                    recepients.append(msg.recepientList.at(i).name);
                } else {
                    recepients.append(msg.recepientList.at(i).name + ", ");
                }
            } else {
                if ((msg.recepientList.count() - i) == 1) {
                    recepients.remove(recepients.length() - 2, 2);
                }
            }
        }
    }

    ui->toLineEdit->setText(recepients);
    ui->toLineEdit->setCursorPosition(0);

    ui->fromLineEdit->setText(msg.senderName);
    ui->fromLineEdit->setCursorPosition(0);
    ui->titleLineEdit->setText(msg.subject());
    ui->titleLineEdit->setCursorPosition(0);
    ui->messageBrowser->setText(msg.text);
    ui->dateLineEdit->setText(msg.time);
}
