#include "widgets/filter/servicefilter.h"

#include <QVBoxLayout>
#include <QList>
#include <QPushButton>
#include <QButtonGroup>
#include <QtDebug>
#include <QToolBar>
#include <QAction>
#include <QVariant>

#include "servicemgr.h"
#include "datatypes/driverinfo.h"

ServiceFilter::ServiceFilter(ServiceMgr* serviceManager, QWidget *parent) :
    QWidget(parent), m_serviceManager(serviceManager)
{
    setLayout(new QVBoxLayout);
    createToolbar();

    m_drivers = serviceManager->getDrivers();
    QAction* act = m_toolbar->addAction(tr("All"));
    act->setData(QVariant::fromValue(static_cast<DriverInfo*>(0)));

    foreach (DriverInfo* driver, m_drivers) {
        addService(driver);
    }
    connect(m_toolbar, SIGNAL(actionTriggered(QAction*)), SLOT(serviceSelected(QAction*)));
}

void ServiceFilter::addService(DriverInfo* driverInfo)
{
    QAction* act = m_toolbar->addAction(driverInfo->icon, "");
    act->setData(QVariant::fromValue(driverInfo));
}

void ServiceFilter::serviceSelected(QAction* act)
{
    emit stateChanged(act->data().value<DriverInfo*>());
}

void ServiceFilter::createToolbar()
{
    m_toolbar = new QToolBar;
    m_toolbar->setOrientation(Qt::Vertical);
#ifdef Q_WS_MAEMO5
    m_toolbar->setMaximumWidth(30);
    layout()->setSpacing(0);
    layout()->setMargin(0);
#endif
    layout()->addWidget(m_toolbar);
}
