# -------------------------------------------------
# Project created by QtCreator 2010-08-12T14:46:35
# -------------------------------------------------
QT = core \
    gui \
    xml \
    network \
    webkit

TARGET_NAME = mysocials

unix: { 
    TARGET = $${TARGET_NAME}
} else {
    TARGET = $$qtLibraryTarget($$TARGET_NAME)
}

VERSION = 1.0

TEMPLATE = lib

CONFIG += link_pkgconfig \
    thread \ 
    # debug_and_release \
    # build_all
    debug

PKGCONFIG += libxml-2.0 \
    glib-2.0

DEFINES += mysocials_LIBRARY

CONFIG (debug, debug|release) {
    OBJECTS_DIR = build/debug
} else {
    OBJECTS_DIR = build/release
}

# include private developer settings
exists(../devel.pri):include(../devel.pri)

DEFINES += LOCALDATADIR=\\\"/.msa/\\\"

isEmpty(PREFIX):PREFIX = $$[QT_INSTALL_PREFIX]
message(prefix is $$PREFIX)

# prefix for search shared files
exists($$PREFIX) { 
    DATAPREFIX = $$PREFIX/share
    DEFINES += DATAPREFIX=\\\"$$DATAPREFIX\\\"
    message(dataprefix is $$DATAPREFIX)
    BINDIR = $$PREFIX/bin
    LIBDIR = $$PREFIX/lib
    !maemo5:contains(QMAKE_HOST.arch, x86_64)::LIBDIR = $$PREFIX/lib64
    INCLUDEDIR = $$PREFIX/include
    DATADIR = $$PREFIX/share
}

RESOURCES += ../data/mysocials_res.qrc

SOURCES += utils/hintedit.cpp \
    utils/QProgressIndicator.cpp \
    utils/utils.cpp \
    servicemgr.cpp \
    qtransport.cpp \
    datatypes/photo.cpp \
    datatypes/account.cpp \
    datatypes/friend.cpp \
    datatypes/album.cpp \
    datatypes/driverinfo.cpp \
    datatypes/message.cpp \
    datatypes/photocomments.cpp \
    datatypes/qerrormessage.cpp \
    datatypes/qeventfeed.cpp \
    datatypes/qattachment.cpp \
    widgets/qmousetrackingview.cpp \
    widgets/qcommentwidget.cpp \
    widgets/qaddcomment.cpp \
    widgets/qimageviewer.cpp \
    widgets/uiaccountsettings.cpp \
    widgets/uiaddaccount.cpp \
    widgets/uihelp.cpp \
    widgets/uinetworksettings.cpp \
    widgets/qdriverslist.cpp \
    widgets/profilebrowser.cpp \
    widgets/messagebrowser.cpp \
    panels/imagebrowserpanel.cpp \
    panels/profilebrowserpanel.cpp \
    panels/messagebrowserpanel.cpp \
    widgets/qtoppanel.cpp \
    widgets/messagecomposer.cpp \
    widgets/qphotouploader.cpp \
    widgets/filter/servicefilter.cpp

HEADER_CORE = mysocials_global.h \
    mysocials_driver.h \
    servicemgr.h \
    qtransport.h

HEADER_UTILS = utils/hintedit.h \
    utils/QProgressIndicator.h \
    utils/utils.h \
    utils/fullscreenexitbutton.h \
    utils/qrefreshlist.h

HEADER_WIDGETS = widgets/qmousetrackingview.h \
    widgets/qcommentwidget.h \
    widgets/qaddcomment.h \
    widgets/qimageviewer.h \
    widgets/uiaccountsettings.h \
    widgets/uiaddaccount.h \
    widgets/uihelp.h \
    widgets/uinetworksettings.h \
    widgets/qdriverslist.h \
    widgets/qtoppanel.h \
    widgets/profilebrowser.h \
    widgets/messagebrowser.h \
    widgets/messagecomposer.h \
    widgets/qphotouploader.h \
    widgets/filter/servicefilter.h

HEADER_DATATYPES = datatypes/photo.h \
    datatypes/account.h \
    datatypes/friend.h \
    datatypes/album.h \
    datatypes/driverinfo.h \
    datatypes/photocomments.h \
    datatypes/qerrormessage.h \
    datatypes/message.h \
    datatypes/qeventfeed.h \
    datatypes/qattachment.h

HEADER_PANELS = panels/imagebrowserpanel.h \
    panels/profilebrowserpanel.h \
    panels/messagebrowserpanel.h

HEADERS += $$HEADER_UTILS \
    $$HEADER_DATATYPES \
    $$HEADER_CORE \
    $$HEADER_WIDGETS \
    $$HEADER_PANELS

FORMS += widgets/qaddcomment.ui \
    widgets/uiaccountsettings.ui \
    widgets/uiaddaccount.ui \
    widgets/uihelp.ui \
    widgets/uinetworksettings.ui \
    widgets/qdriverslist.ui \
    widgets/profilebrowser.ui \
    widgets/messagebrowser.ui \
    panels/imagebrowserpanel.ui \
    panels/profilebrowserpanel.ui \
    panels/messagebrowserpanel.ui \
    widgets/messagecomposer.ui \
    widgets/qphotouploader.ui

CODECFORSRC = UTF-8

TRANSLATIONS = ../translations/$${TARGET_NAME}_core_ru.ts

system("sed -e 's:@prefix@:$$PREFIX:g;s:@exec_prefix@:$$BINDIR:g;s:@libdir@:$$LIBDIR:g;s:@includedir@:$$INCLUDEDIR/mysocials:g;s:@VERSION@:$$VERSION:g' ../data/mysocials-dev.pc.in >../data/mysocials-dev.pc")
system("sed -e 's:@prefix@:$$PREFIX:g;s:@exec_prefix@:$$BINDIR:g;s:@libdir@:$$LIBDIR:g;s:@includedir@:$$INCLUDEDIR/mysocials:g;s:@VERSION@:$$VERSION:g' ../data/mysocials-core.pc.in >../data/mysocials-core.pc")

# make install
INSTALLS += target \
    pkgconfig \
    header_core \
    header_utils \
    header_types \
    header_widgets \
    header_panels \
    translations

target.path = $$LIBDIR

pkgconfig.path = $$LIBDIR/pkgconfig
pkgconfig.files = ../data/*.pc

translations.path = $$DATADIR/qt4/translations/
translations.files = ../translations/*.qm

header_core.path = $$INCLUDEDIR/mysocials
header_core.files = $$HEADER_CORE

header_utils.path = $$INCLUDEDIR/mysocials/utils
header_utils.files = $$HEADER_UTILS

header_types.path = $$INCLUDEDIR/mysocials/datatypes
header_types.files = $$HEADER_DATATYPES

header_widgets.path = $$INCLUDEDIR/mysocials/widgets
header_widgets.files = $$HEADER_WIDGETS

header_panels.path = $$INCLUDEDIR/mysocials/panels
header_panels.files = $$HEADER_PANELS

# library documentation
htmldocs.path = $$DATADIR/doc/mysocials-core
htmldocs.files = ../doc/html*
INSTALLS += htmldocs

qtdocs.path = $$DATADIR/qt4/doc/qch
qtdocs.files = ../doc/*.qch
INSTALLS += qtdocs
