/**
 * \file mysocials_driver.h
 * \brief interface for module developers
 *
 * Copyright (C) 2009, 2010, 2011 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MAS program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MAS program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef _MYSOCIALS_DRIVER_H_
#define _MYSOCIALS_DRIVER_H_

#include <glib.h>

#include <libxml/tree.h>
#include <libxml/parser.h>

#define CLASS_SETTINGS "settings"
#define GET_SETTINGS "getSettings"
#define SET_SETTINGS "setSettings"
#define TEST_CONNECTION "testConnection"
#define GET_LIST_METHODS "getListMethods"

#define CLASS_PROFILE "profile"
#define GET_PROFILE "getProfile"
#define GET__BASE_PROFILE "getBaseProfile"
#define SET_PROFILE "setProfile"

#define CLASS_PHOTOS "photos"
#define CREATE_ALBUM "createAlbum"
#define GET_LIST_ALBUMS "getListAlbums"
#define GET_LIST_PHOTOS "getListPhotos"
#define GET_LIST_USER_PHOTOS "getListUserPhotos"
#define GET_LIST_FAVORITE_PHOTOS "getListFavoritePhotos"
#define GET_PHOTO "getPhoto"
#define GET_LIST_PHOTO_TAGS "getListPhotoTags"
#define GET_LIST_PHOTO_COMMENTS "getListPhotoComments"
#define SEND_PHOTO_COMMENT "sendPhotoComment"
#define UPLOAD_PHOTO "uploadPhoto"

#define CLASS_FRIENDS "friends"
#define GET_LIST_FRIENDS "getListFriends"
#define DELETE_FRIEND "deleteFriend"

#define CLASS_MESSAGES "messages"
#define GET_LIST_INBOX_MESSAGES "getListInboxMessages"
#define GET_LIST_OUTBOX_MESSAGES "getListOutboxMessages"
#define GET_TOTAL_COUNT_INBOX "getTotalCountInbox"
#define GET_TOTAL_COUNT_OUTBOX "getTotalCountOutbox"
#define GET_COUNT_INBOX_BYTIME "getCountInboxByTime"
#define GET_COUNT_OUTBOX_BYTIME "getCountOutboxByTime"

#define GET_NEW_MESSAGES "getNewInboxMessages"
#define READ_MESSAGE "readMessage"
#define SEND_MESSAGE "sendMessage"
#define DELETE_MESSAGE "deleteMessage"
#define GET_LIST_WALL_MESSAGES "getListWallMessages"
#define SEND_WALL_MESSAGE "sendWallMessage"
#define GET_TOTAL_COUNT_WALL "getTotalCountWall" 
#define DELETE_WALL_MESSAGE "deleteWallMessage"

#define CLASS_AUDIO "audio"
#define GET_LIST_AUDIO "getListAudio"

#define CLASS_NEWS "news"
#define GET_LIST_NEWS "getListNews"

#define CLASS_SYSTEM_MESSAGES "systemMessages"
#define INFO_MESSAGE "infoMessage"
#define ERROR_MESSAGE "errorMessage"

/**
  \brief Save settings error.

  This error caused when used try to set settings to driver which driver can't recognize.
  */
#define DRV_SETT_ERROR_CODE "101"
/**
  \brief Authorisation process finished with error.

  This error may caused when webauth not found.
  */
#define DRV_AUTH_ERROR_CODE "102"

/**
  \brief Authorization process canceled by user.
  */
#define DRV_AUTH_CANCEL_CODE "103"

/**
  \brief Unknown method was called error.

  This error caused when application try to use unknown method.
  */
#define DRV_UNKNOWN_METHOD_CALL "104"

/*common*/
#define DRV_REQ_ERROR_CODE "201"
#define DRV_REQ_PARAM_CODE "202" 
#define DRV_MESS_EMPTY_CODE "203"
#define DRV_SERVER_BUSY_CODE "204"
#define DRV_CAPT_ERROR_CODE "205"
#define DRV_ACCESS_ERROR_CODE "206"
#define DRV_SERVER_ERROR_CODE "207"
#define DRV_NETW_ERROR_CODE "208"
#define DRV_RESP_ERROR_CODE "209"
#define DRV_FILE_SAVE_ERROR_CODE "210"

/** Driver message text **/
#define DRV_SETT_ERROR "Unable to save settings"
#define L10N_DRV_SETT_ERROR _("Unable to save settings")

#define DRV_AUTH_ERROR "Authorization problem"
#define L10N_DRV_AUTH_ERROR _("Authorization problem")

#define DRV_AUTH_CANCEL "Authorization canceled"
#define L10N_DRV_AUTH_CANCEL _("Authorization canceled")

#define DRV_REQ_ERROR "Unable to perform request"
#define L10N_DRV_REQ_ERROR _("Unable to perform request")

#define DRV_SERVER_BUSY "Server busy"
#define L10N_DRV_SERVER_BUSY _("Server busy")

#define DRV_REQ_PARAM "One of the parameters missing or invalid" 
#define L10N_DRV_REQ_PARAM _("One of the parameters missing or invalid")

#define DRV_CAPT_ERROR "Captcha"
#define L10N_DRV_CAPT_ERROR _("Captcha")

#define DRV_RESP_ERROR "Bad response from server"
#define L10N_DRV_RESP_ERROR _("Bad response from server")

#define DRV_NETW_ERROR "Network problem"
#define L10N_DRV_NETW_ERROR _("Network problem")

#define DRV_MESS_LEN "Empty message"
#define L10N_DRV_MESS_LEN _("Empty message")

#define DRV_ACCESS_ERROR "Operation prohibited by privacy"
#define L10N_DRV_ACCESS_ERROR _("Operation prohibited by privacy")

#define DRV_SERVER_ERROR "Internal Server Error"
#define L10N_DRV_SERVER_ERROR _("Internal Server Error")

#define DRV_FILE_SAVE_ERROR "Can't save file"
#define L10N_DRV_FILE_SAVE_ERROR _("Can't save file")

/* Entity names */
#define FIRST_NAME "FirstName"
#define L10N_FIRST_NAME _("FirstName")

#define LAST_NAME "LastName"
#define L10N_LAST_NAME _("LastName")

#define ACTIVITY "Activity"
#define L10N_ACTIVITY _("Activity")

#define CITY_NAME "CityName"
#define L10N_CITY_NAME _("CityName")

#define COUNTRY_NAME "CountryName"
#define L10N_COUNTRY_NAME _("CountryName")

#define BIRTHDAY_NAME "Birthday"
#define L10N_BIRTHDAY_NAME _("Birthday")

#define GENDER_NAME "Gender"
#define L10N_GENDER_NAME _("Gender")

#define FAMILY_STATE_NAME "FamilyState"
#define L10N_FAMILY_STATE_NAME _("FamilyState")

#define POLITICAL_VIEW_NAME "PoliticalView"
#define L10N_POLITICAL_VIEW_NAME _("PoliticalView")

/* Entity values */
#define MALE "male"
#define L10N_MALE _("male")

#define FEMALE "female"
#define L10N_FEMALE _("female")

#define NO_MALE "none"
#define L10N_NO_MALE _("none")


/* Error Code */
typedef enum {
    FAILURE = -1,
    SUCCESS = 0,
    ERROR_ALLOCATION_OF_MEMORY,
    ERROR_NO_FUNCTION,
    ERROR_INITIALIZATION_ALREADY_PASSED,
    ERROR_IS_BUSY,
    ERROR_SEND_DATA,
    ERROR_PARSE_DATA
} error_type;

/*
 * Names of exported function
 */
#define MODULE_INIT "msa_module_init"
#define MODULE_GET_INFO "msa_module_get_info"

/** @struct msa_module
 *  @brief Id info and interface functions for external modules
 *
 *  Each module should implement function named
 *  int init_module(msa_module *mod)
 *  which fills in the fields of this structure and link
 *  appropriate functions to function pointers
 *  @see msa_module_type
 */
struct msa_module {
    gchar* id;                /**< \brief Module ID, a null-terminated string*/
    gchar* name;              /**< \brief Module name for UI purposes */
    gchar* driverName;        /**< \brief Module name for system purposes (equal initial ID) */
    gchar* pic;               /**< \brief Module icon for UI purposes */
    gchar* proxy;
    gint port;

    /** \brief Receives transmitted data to the module
     *
     *  @param data Data in XML, encoded in UTF-8

     *  @param info - information about proxy and port

     *  @return Error code for data transfer operatio

     *  @retval 0 data transfer succeeded
     */
    error_type (*send)(xmlDocPtr request, xmlDocPtr* response, const struct msa_module* info);

    error_type (*shutdown)(const struct msa_module* info);

};


#endif
