#ifndef QATTACHMENT_H
#define QATTACHMENT_H

#include <QObject>
#include <QDomDocument>

#define NODE_ATTACH_ROOT "attach"

#define NODE_ATTACH_ID "id"

#define NODE_ATTACH_OWNERID "ownerId"

#define NODE_ATTACH_TYPE "type"

#define NODE_ATTACH_NAME "name"

#define NODE_ATTACH_ALBUMID "albumId"

#define NODE_ATTACH_ICONURL "iconUrl"

#define NODE_ATTACH_ICON "icon"

#define NODE_ATTACH_OBJECT "object"

#define NODE_ATTACH_IMAGE "image"

#define NODE_ATTACH_DURATION "duration"

/**
  \brief Store attachment data of event or message.
  */
class QAttachment : public QObject
{
    Q_OBJECT
public:
    explicit QAttachment(QObject *parent = 0);

    /**
      \brief The copy constructor.

      \param src The source instance of QAttachment class.
      */
    QAttachment(const QAttachment& src);

    enum AttachmentType {
        ImageAttach,
        VideoAttach,
        AudioAttach,
        LinkAttach,
        NoteAttach
    };

    /**
      \brief The object ID.
      */
    QString id;

    /**
      \brief The ID of author.
      */
    QString ownerId;

    /**
      \brief The type of attachment.
      */
    AttachmentType type;

    /**
      \brief The name of attached object.

      Used at image, audio, link, note and video attachment.
      */
    QString name;

    /**
      \brief The album Id.

      Used at image attachment.
      */
    QString albumId;

    /**
      \brief The URL to small image/icon.

      Used at image, link and video attachment.
      */
    QString iconUrl;

    /**
      \brief The path to small image/icon file.

      Used at image, link and video attachment.
      */
    QString icon;

    /**
      \brief The URL to origin object.

      Used at image, audio, link, note and video attachment.
      */
    QString objectUrl;

    /**
      \brief The path to image file.

      Used at image attachment.
      */
    QString image;

    /**
      \brief The video duration.

      Used at video and audio attachment.
      */
    QString duration;

    static void copyData(QAttachment *dst, const QAttachment *src);

    QAttachment& operator=(const QAttachment& src);

    /*!
     \brief Store attachment data to XML format.

     \param doc root XML document

     \return XML structure
     */
    QDomElement toQDomElement(QDomDocument& doc) const;

    static QAttachment fromQDomElement(const QDomElement& fr, const QString& accountId);

};

#endif // QATTACHMENT_H
