#include "qattachment.h"

QAttachment::QAttachment(QObject *parent) :
    QObject(parent)
{
}

QAttachment::QAttachment(const QAttachment &src) :
        QObject(src.parent())
{
    this->copyData(this, &src);
}

void QAttachment::copyData(QAttachment *dst, const QAttachment *src)
{
    dst->albumId = src->albumId;
    dst->duration = src->duration;
    dst->icon = src->icon;
    dst->iconUrl = src->iconUrl;
    dst->id = src->id;
    dst->image = src->image;
    dst->name = src->name;
    dst->objectUrl = src->objectUrl;
    dst->ownerId = src->ownerId;
    dst->type = src->type;
}

QAttachment& QAttachment::operator =(QAttachment const& src)
{
    QAttachment::copyData(this, &src);
    return *this;
}

QDomElement QAttachment::toQDomElement(QDomDocument &doc) const
{
    QDomElement ret = doc.createElement(NODE_ATTACH_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_ATTACH_ID);
    QDomText t = doc.createTextNode(this->id);
    ret.appendChild(node);
    node.appendChild(t);

    // owner ID
    node = doc.createElement(NODE_ATTACH_OWNERID);
    t = doc.createTextNode(this->ownerId);
    ret.appendChild(node);
    node.appendChild(t);

    // type
    node = doc.createElement(NODE_ATTACH_TYPE);
    switch(this->type)
    {
    case ImageAttach:
        t = doc.createTextNode("image");
        break;
    case VideoAttach:
        t = doc.createTextNode("video");
        break;
    case AudioAttach:
        t = doc.createTextNode("audio");
        break;
    case LinkAttach:
        t = doc.createTextNode("link");
        break;
    case NoteAttach:
        t = doc.createTextNode("note");
        break;
    }
    ret.appendChild(node);
    node.appendChild(t);

    // name
    if (!this->name.isEmpty())
    {
        node = doc.createElement(NODE_ATTACH_NAME);
        t = doc.createTextNode(this->name);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // albumId
    if (!this->albumId.isEmpty())
    {
        node = doc.createElement(NODE_ATTACH_ALBUMID);
        t = doc.createTextNode(this->albumId);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // icon URL
    if (!this->iconUrl.isEmpty())
    {
        node = doc.createElement(NODE_ATTACH_ICONURL);
        t = doc.createTextNode(this->iconUrl);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // icon
    if (!this->icon.isEmpty())
    {
        node = doc.createElement(NODE_ATTACH_ICON);
        t = doc.createTextNode(this->icon);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // object URL
    if (!this->objectUrl.isEmpty())
    {
        node = doc.createElement(NODE_ATTACH_OBJECT);
        t = doc.createTextNode(this->objectUrl);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // image
    if (!this->image.isEmpty())
    {
        node = doc.createElement(NODE_ATTACH_IMAGE);
        t = doc.createTextNode(this->image);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // duration
    if (!this->duration.isEmpty())
    {
        node = doc.createElement(NODE_ATTACH_DURATION);
        t = doc.createTextNode(this->duration);
        ret.appendChild(node);
        node.appendChild(t);
    }

    return ret;
}

QAttachment QAttachment::fromQDomElement(const QDomElement &fr, const QString &accountId)
{
    QAttachment ret;

    if (fr.elementsByTagName(NODE_ATTACH_ID).count() > 0)
        ret.id = fr.elementsByTagName(NODE_ATTACH_ID).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_ALBUMID).count() > 0)
        ret.albumId = fr.elementsByTagName(NODE_ATTACH_ALBUMID).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_OBJECT).count() > 0)
        ret.objectUrl = fr.elementsByTagName(NODE_ATTACH_OBJECT).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_NAME).count() > 0)
        ret.name = fr.elementsByTagName(NODE_ATTACH_NAME).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_ICON).count() > 0)
        ret.icon = fr.elementsByTagName(NODE_ATTACH_ICON).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_IMAGE).count() > 0)
        ret.image = fr.elementsByTagName(NODE_ATTACH_IMAGE).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_DURATION).count() > 0)
        ret.duration = fr.elementsByTagName(NODE_ATTACH_DURATION).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_ICONURL).count() > 0)
        ret.iconUrl = fr.elementsByTagName(NODE_ATTACH_ICONURL).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_OWNERID).count() > 0)
        ret.ownerId = fr.elementsByTagName(NODE_ATTACH_OWNERID).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ATTACH_TYPE).count() > 0)
    {
        QString tp = fr.elementsByTagName(NODE_ATTACH_TYPE).at(0).firstChild().toText().data();
        if (tp.compare("image") == 0)
            ret.type = ImageAttach;
        else if (tp.compare("video") == 0)
            ret.type = VideoAttach;
        else if (tp.compare("audio") == 0)
            ret.type = AudioAttach;
        else if (tp.compare("link") == 0)
            ret.type = LinkAttach;
        else
            ret.type = NoteAttach;
    }

    return ret;
}
