#include "qtoppanel.h"

QTopPanel::QTopPanel(QWidget *parent) :
    QWidget(parent)
{
    QHBoxLayout *layout = new QHBoxLayout();
    this->setLayout(layout);

    this->back = new QPushButton(this);
    this->back->setFlat(true);
    layout->addWidget(this->back);
    this->icon = new QLabel(this);
    layout->addWidget(this->icon);
    this->text = new QLabel(this);
    layout->addWidget(this->text);
    this->refresh = new QPushButton(this);
    this->refresh->setFlat(true);
    layout->addWidget(this->refresh);

    // connect signals
    connect(this->back, SIGNAL(clicked()), this, SIGNAL(backPressed()));
    connect(this->refresh, SIGNAL(clicked()), this, SIGNAL(refreshPressed()));
}

QTopPanel::~QTopPanel()
{
}

void QTopPanel::setPixmap(QPixmap icon)
{
    this->icon->setPixmap(icon);
}

void QTopPanel::setText(QString text)
{
    this->text->setText(text);
}

void QTopPanel::setBackIcon(QIcon icon)
{
    this->back->setIcon(icon);
}

void QTopPanel::setRefreshIcon(QIcon icon)
{
    this->refresh->setIcon(icon);
}

void QTopPanel::mousePressEvent(QMouseEvent * event)
{
    event->accept();
    if (event->button() == Qt::LeftButton)
        emit this->clicked();
}
