#ifndef IMAGEBROWSERPANEL_H
#define IMAGEBROWSERPANEL_H

#include <QWidget>
#include <QPushButton>
#include <QListWidget>
#include <QMessageBox>
#include <QRadioButton>
#include <QString>

#include "widgets/qimageviewer.h"
#include "widgets/qtoppanel.h"
#include "utils/hintedit.h"

#include "datatypes/friend.h"
#include "datatypes/album.h"
#include "datatypes/photo.h"

#include "servicemgr.h"

namespace Ui {
    class ImageBrowserPanel;
}

class ImageBrowserPanel : public QWidget
{
    Q_OBJECT

public:
    explicit ImageBrowserPanel(QWidget *parent = 0);
    explicit ImageBrowserPanel(ServiceMgr *mgr, QWidget *parent = 0);
    ~ImageBrowserPanel();

    void init();

    void hideAll(QLayout *layout);
    void showAll(QLayout *layout);
    void clearEditOwnr();

    // window state for 2 panel mode. First panel is current, Last panel is previous
    enum WindowState {
        WindowFriendAlbum,
        WindowAlbumPhoto,
        WindowPhotoAlbum,
        WindowAlbumFriend
    };

    // update window corresponding current state
    void setState(WindowState state);
    void setState();

private:
    void setAlbumHeader();
    void setAlbumHeader(Friend fr);
    void setPhotoHeader();
    void setPhotoHeader(Album al);
    static QString albumItem(Album al);
    static QPixmap albumIcon(Album al);
    static QPixmap photoIcon(Photo al);


private:
    Ui::ImageBrowserPanel *ui;
    QTopPanel *albumsTopPanel;
    QTopPanel *photosTopPanel;


    QFont usedFont;

    //QLabel lablContacts;
    HintEdit *editOwnr;
    QPushButton *buttonEditOwnr;
    QPushButton *buttonRefreshFriends;
    //QPushButton *buttonRefreshAlbums;
    //QPushButton *buttonRefreshPhotos;
    //QPushButton *buttonCloseAlbums;
    //QPushButton *buttonClosePhotos;

    ServiceMgr *sm;

    bool isFriendsUpdate;
    bool isAlbumsUpdate;
    bool isPhotosUpdate;

    // current state for window
    WindowState state;
    bool isPortraitMode;

    void ownrSelected(QListWidgetItem *item, bool isNeedUpdateState);

    QListWidgetItem *createFriendWidget(Friend fr);
    void addMeToFriends();

signals:
    void openImage(Photo photo);
    void showFriendInfo(Friend fr);
    void showAlbumInfo(Album al);

private slots:
    //void on_pushButtonMe_toggled(bool checked);
    void editOwnr_textChanged(QString str);
    void buttonResetOwnr_clicked();

    void ownrSelected(QListWidgetItem *item);
    void albmSelected(QListWidgetItem *item);
    void photoSelected(QListWidgetItem *item);

    void albumHeaderClicked();
    void photoHeaderClicked();

    void refreshFriends();
    void refreshFriends(bool isNeedUpdate);
    void refreshAlbums();
    void refreshAlbums(bool isNeedUpdate);
    void refreshPhotos();
    void refreshPhotos(bool isNeedUpdate);

    void hidePhotos();
    void hideAlbums();

    void orientationChanged();

    void updateListFriends(FriendList list, bool isLastUpdate);
    void updateListAlbums(QString friendId, AlbumList, bool isLastUpdate);
    void updateListPhotos(QString albumId, PhotoList, bool isLastUpdate);
};

#endif // IMAGEBROWSERPANEL_H
