
#include "friend.h"

Friend::Friend()
    :QObject(0)
{
}

Friend::Friend(const Friend & src)
    :QObject(src.parent())
{
    Friend::copyData(this, &src);
}

Friend::~Friend()
{
}

QString Friend::name()
{
    QString ret = tr("Unknown");

    if (this->firstName.isEmpty() && this->lastName.isEmpty())
        ret = this->nickName;
    else
        ret = this->firstName;

    if (!(this->firstName.isEmpty() && this->lastName.isEmpty()))
        ret += " ";

    ret += this->lastName;

    return ret;
}

void Friend::copyData(Friend *dst, const Friend *src)
{
    dst->accountId = src->accountId;
    dst->birthday = src->birthday;
    dst->city = src->city;
    dst->country = src->country;
    dst->firstName = src->firstName;
    dst->gender = src->gender;
    dst->homePhone = src->homePhone;
    dst->icon = src->icon;
    dst->icon_url = src->icon_url;
    dst->id = src->id;
    dst->lastName = src->lastName;
    dst->mobilePhone = src->mobilePhone;
    dst->nickName = src->nickName;
    dst->online = src->online;
}

QDomElement Friend::toQDomElement(QDomDocument doc, Friend src) {
    QDomElement ret = doc.createElement(NODE_FRIEND_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_FRIEND_ID);
    QDomText t = doc.createTextNode(src.id);
    ret.appendChild(node);
    node.appendChild(t);

    // First Name
    node = doc.createElement(NODE_FRIEND_FIRST_NAME);
    t = doc.createTextNode(src.firstName);
    ret.appendChild(node);
    node.appendChild(t);

    // Nick Name
    node = doc.createElement(NODE_FRIEND_NICK_NAME);
    t = doc.createTextNode(src.nickName);
    ret.appendChild(node);
    node.appendChild(t);

    // Last Name
    node = doc.createElement(NODE_FRIEND_LAST_NAME);
    t = doc.createTextNode(src.lastName);
    ret.appendChild(node);
    node.appendChild(t);

    // avatar
    node = doc.createElement(NODE_FRIEND_ICON);
    t = doc.createTextNode(src.icon);
    ret.appendChild(node);
    node.appendChild(t);

    // avatar url
    node = doc.createElement(NODE_FRIEND_ICON_URL);
    t = doc.createTextNode(src.icon_url);
    ret.appendChild(node);
    node.appendChild(t);

    // gender
    node = doc.createElement(NODE_FRIEND_GENDER);
    t = doc.createTextNode(src.gender);
    ret.appendChild(node);
    node.appendChild(t);

    // birthday
    node = doc.createElement(NODE_FRIEND_BIRTHDAY);
    t = doc.createTextNode(src.birthday);
    ret.appendChild(node);
    node.appendChild(t);

    // mobile phone
    node = doc.createElement(NODE_FRIEND_MOBILE_PHONE);
    t = doc.createTextNode(src.mobilePhone);
    ret.appendChild(node);
    node.appendChild(t);

    // home phone
    node = doc.createElement(NODE_FRIEND_HOME_PHONE);
    t = doc.createTextNode(src.homePhone);
    ret.appendChild(node);
    node.appendChild(t);

    // city
    node = doc.createElement(NODE_FRIEND_CITY);
    t = doc.createTextNode(src.city);
    ret.appendChild(node);
    node.appendChild(t);

    // country
    node = doc.createElement(NODE_FRIEND_COUNTRY);
    t = doc.createTextNode(src.country);
    ret.appendChild(node);
    node.appendChild(t);

    return ret;
}

Friend Friend::fromQDomElement(QDomElement fr, QString accountId) {
    Friend ret = Friend();

    ret.id = fr.elementsByTagName(NODE_FRIEND_ID).at(0).firstChild().toText().data();
    ret.firstName = fr.elementsByTagName(NODE_FRIEND_FIRST_NAME).at(0).firstChild().toText().data();
    ret.nickName = fr.elementsByTagName(NODE_FRIEND_NICK_NAME).at(0).firstChild().toText().data();
    ret.lastName = fr.elementsByTagName(NODE_FRIEND_LAST_NAME).at(0).firstChild().toText().data();
    ret.icon = fr.elementsByTagName(NODE_FRIEND_ICON).at(0).firstChild().toText().data();
    ret.icon_url = fr.elementsByTagName(NODE_FRIEND_ICON_URL).at(0).firstChild().toText().data();
    ret.gender = fr.elementsByTagName(NODE_FRIEND_GENDER).at(0).firstChild().toText().data();
    ret.birthday = fr.elementsByTagName(NODE_FRIEND_BIRTHDAY).at(0).firstChild().toText().data();
    ret.mobilePhone = fr.elementsByTagName(NODE_FRIEND_MOBILE_PHONE).at(0).firstChild().toText().data();
    ret.homePhone = fr.elementsByTagName(NODE_FRIEND_HOME_PHONE).at(0).firstChild().toText().data();
    ret.city = fr.elementsByTagName(NODE_FRIEND_CITY).at(0).firstChild().toText().data();
    ret.country = fr.elementsByTagName(NODE_FRIEND_COUNTRY).at(0).firstChild().toText().data();
    ret.accountId = accountId;

    return ret;
}

AlbumList Friend::getAlbumList() {
    AlbumList ret;
    QFile file(Utils::getAccountDir(this->accountId) + QString(FILE_ALBUMS_DATA).arg(this->id));
    if (file.open(QIODevice::ReadOnly) == false)
        return ret;

    QDomDocument doc;
    doc.setContent(&file);
    file.close();

    QDomNodeList lst = doc.elementsByTagName(NODE_ALBUM_ROOT);

    qDebug() << "Start load of " << lst.length() << " albums for " << this->id;
    for (uint i = 0; i < lst.length(); i++) {
        ret.append(Album::fromQDomElement(lst.at(i).toElement(), this->accountId, this->id));
    }

    return ret;

}

void Friend::setAlbumList(AlbumList list, QString accountId, QString friendId) {

    if (friendId.isEmpty())
        return;

    // store albums into cache
    QDomDocument out("MyDoc");
    QDomElement profile = out.createElement(NODE_ALBUMS_ROOT);
    out.appendChild(profile);

    for (int i = 0; i < list.length(); i++) {
        profile.appendChild(list[i].toQDomElement(out));
    }

    QDir dir;

    dir.setPath(dir.cleanPath(Utils::getAccountDir(accountId)));
    if (!dir.exists())
        dir.mkpath(dir.absolutePath());

    QFile file(dir.absolutePath() + "/" + QString(FILE_ALBUMS_DATA).arg(friendId));
    qDebug() << file.fileName();
    if (file.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate) == false) {
        qDebug() << "can't open file: " + file.errorString();
    }
    //file.write(output.toUtf8());
    file.write(out.toByteArray(1));
    file.close();

}

Friend& Friend::operator =(const Friend& src)
                          {
//    Friend *ret = new Friend(src);
//    qDebug() << "operator=(" << src.name << ", " << ret->name;
//    return *ret;
    Friend::copyData(this, &src);

    return *this;
}

void Friend::storeData()
{
    if (this->accountId.isEmpty() || this->id.isEmpty())
        return;

    // store albums into cache
    QDomDocument out("MyDoc");

    out.appendChild(this->toQDomElement(out, *this));

    QDir dir;

    dir.setPath(dir.cleanPath(Utils::getAccountDir(this->accountId)));
    if (!dir.exists())
        dir.mkpath(dir.absolutePath());

    QFile file(dir.absolutePath() + "/" + QString(FILE_OWNER_DATA).arg(this->id));
    qDebug() << file.fileName();
    if (file.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate) == false) {
        qDebug() << "can't open file: " + file.errorString();
    }
    //file.write(output.toUtf8());
    file.write(out.toByteArray(1));
    file.close();
}

Friend Friend::loadData(QString accountId, QString ownerId)
{
    Friend ret;
    QFile file(Utils::getAccountDir(accountId) + QString(FILE_OWNER_DATA).arg(ownerId));
    if (file.open(QIODevice::ReadOnly) == false)
        return ret;

    QDomDocument doc;
    doc.setContent(&file);
    file.close();

    return Friend::fromQDomElement(doc.firstChildElement(), accountId);
}
