#ifndef UIACCOUNTSETTINGS_H
#define UIACCOUNTSETTINGS_H

#include <QDialog>

#include "datatypes/account.h"
#include "datatypes/driverinfo.h"
#include "uiaddaccount.h"
#include <servicemgr.h>

namespace Ui {
    class UIAccountSettings;
}

class UIAccountSettings : public QDialog
{
    Q_OBJECT

public:
    explicit UIAccountSettings(ServiceMgr *sm, QWidget *parent = 0);
    ~UIAccountSettings();

    /**
     * @brief shows settings page with add new account form
     *
    */
    void addNewAccount();

private:
    Ui::UIAccountSettings *ui;

    ServiceMgr *sm;

private slots:
    void on_btnAddNew_clicked();

    void updateAccounts(AccountList);

    void selectAccount();

    void on_btnRemove_clicked();

    void on_btnReconnect_clicked();
};

#endif // UIACCOUNTSETTINGS_H
