#ifndef QMOUSETRACKINGWIDGET_H
#define QMOUSETRACKINGWIDGET_H

#include <QWidget>
#include <QMouseEvent>
#include <QDebug>
#include <QGraphicsView>
#include <QApplication>
#include <QScrollBar>
#include <QMouseEvent>

#ifdef Q_WS_MAEMO_5
#define NUM_MOVE_EVENTS 5
#else
#define NUM_MOVE_EVENTS 10
#endif

class QMouseTrackingView : public QGraphicsView
{
    Q_OBJECT

public:
    QMouseTrackingView(QGraphicsScene *scene, QWidget *parent);
    void reset();

private:
    QList<QPoint> mousePoints;

    void getDirection();
    QMouseEvent lastMouseEvent;
    void storeMouseEvent(QMouseEvent *event);

signals:
    void mouseDragged(Qt::ArrowType);
    void mouseDoubleClick();

public slots:
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);

};

#endif // QMOUSETRACKINGWIDGET_H
