#ifndef QCOMMENTWIDGET_H
#define QCOMMENTWIDGET_H

#include <QWidget>
#include <QPicture>
#include <QDateTime>
#include <QHBoxLayout>
#include <QLabel>
#include <QTextBrowser>
#include <QIcon>

#include "datatypes/photocomments.h"
#include "datatypes/friend.h"

#define ICON_SIZE 60

class QCommentWidget : public QWidget
{
    Q_OBJECT

public:
    explicit QCommentWidget(QFont textFont, QWidget *parent = 0);
    ~QCommentWidget();

    void setPhotoComment(PhotoComment comment);
    void setSenderProfile(Friend fr);
    PhotoComment photoComment();

    QDateTime dateTime();

    virtual int heightForWidth(int width) const;
    virtual QSize sizeHint() const;
    void setWidth(int width);

private:
    void setupUi(QFont textFont);
    void updateIcon();
    void setName();

    // UI
    QLabel *icon;
    QLabel *name;
    QLabel *date;
    QTextBrowser *text;

    PhotoComment pComment;
    Friend senderProfile;
};

#endif // QCOMMENTWIDGET_H
