#include "imagebrowserpanel.h"
#include "ui_imagebrowserpanel.h"

ImageBrowserPanel::ImageBrowserPanel(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::ImageBrowserPanel), state(WindowFriendAlbum), isPortraitMode(false)
{
    this->sm = new ServiceMgr(this);
    ui->setupUi(this);
    init();

    this->isFriendsUpdate = false;
    this->isAlbumsUpdate = false;
    this->isPhotosUpdate = false;

    //connect to signals from service manager
    connect(sm, SIGNAL(updateFriends(FriendList, bool)), this, SLOT(updateListFriends(FriendList, bool)));
    connect(sm, SIGNAL(updateAlbumList(QString,AlbumList, bool)), this, SLOT(updateListAlbums(QString,AlbumList, bool)));
    connect(sm, SIGNAL(updatePhotoList(QString,PhotoList, bool)), this, SLOT(updateListPhotos(QString,PhotoList, bool)));

    // check that one acount mast be setup
    if (this->sm->getAccounts().length() != 0)
    {
        this->updateListFriends(sm->getFriends(false, true), true);
    }

    this->setState();
}

ImageBrowserPanel::ImageBrowserPanel(ServiceMgr *mgr, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ImageBrowserPanel), state(WindowFriendAlbum), isPortraitMode(false)
{
    this->sm = mgr;
    ui->setupUi(this);
    init();

    this->isFriendsUpdate = false;
    this->isAlbumsUpdate = false;
    this->isPhotosUpdate = false;

    //connect to signals from service manager
    connect(sm, SIGNAL(updateFriends(FriendList, bool)), this, SLOT(updateListFriends(FriendList, bool)));
    connect(sm, SIGNAL(updateAlbumList(QString,AlbumList, bool)), this, SLOT(updateListAlbums(QString,AlbumList, bool)));
    connect(sm, SIGNAL(updatePhotoList(QString,PhotoList, bool)), this, SLOT(updateListPhotos(QString,PhotoList, bool)));

    // check that one acount mast be setup
    if (this->sm->getAccounts().length() != 0)
    {
        this->updateListFriends(sm->getFriends(false, true), true);
    }

    this->setState();
}

ImageBrowserPanel::~ImageBrowserPanel()
{
    delete ui;
}

void ImageBrowserPanel::init()
{
    //user
    //ui->pushButtonLogout->setIcon(QIcon::fromTheme("general_settings"));
    //ui->pushButtonLogout->setFlat(TRUE);
//    ui->pushButtonMe->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));
//    ui->pushButtonMe->setStyleSheet("text-align: left; image-position: left;");
    QRadioButton *radb = new QRadioButton(tr("People"));
    radb->toggle();
    radb->setEnabled(FALSE);
    ui->layoutFriendsTop->addWidget(radb, 1);
    radb = new QRadioButton(tr("News"));
    radb->setEnabled(FALSE);
    ui->layoutFriendsTop->addWidget(radb, 1);
    ui->layoutFriendsTop->setSpacing(0);

    //friends list
    QIcon icon;
    //icon = QIcon::fromTheme("general_contacts", QIcon(":/res/general_contacts.png"));
    //lablContacts.setPixmap(icon.pixmap(48, QIcon::Normal, QIcon::On));
    //lablContacts.setAlignment(Qt::AlignCenter);
    ui->layoutFriendsTop->addWidget(buttonRefreshFriends = new QPushButton(this), 0);
    buttonRefreshFriends->setFlat(TRUE);
    buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));

    ui->listFriends->setStyleSheet("text-align: left; image-position: center;");
    ui->listFriends->setFont(this->usedFont);


    //friends filter
    ui->layoutFriendsBottom->addWidget(editOwnr = new HintEdit(this));
    ui->layoutFriendsBottom->addWidget(buttonEditOwnr = new QPushButton(this));

    buttonEditOwnr->setIcon(QIcon::fromTheme("general_backspace", QIcon(":/res/general_backspace.png")));
    buttonEditOwnr->setFlat(TRUE);
    editOwnr->setHintText(tr("Type a name..."));

    //albums
    this->albumsTopPanel = new QTopPanel(this);
    this->ui->layoutAlbums->insertWidget(0, this->albumsTopPanel);

    icon = QIcon::fromTheme("tasklaunch_photos", QIcon(":/res/tasklaunch_photos.png"));
    this->albumsTopPanel->setPixmap(icon.pixmap(48, QIcon::Normal, QIcon::On));

    this->albumsTopPanel->setRefreshIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    this->albumsTopPanel->setBackIcon(QIcon::fromTheme("general_back", QIcon(":/res/general_back.png")));

    this->ui->listAlbums->setFont(this->usedFont);
    this->albumsTopPanel->setFont(this->usedFont);

    //photos
    this->photosTopPanel = new QTopPanel(this);
    this->ui->layoutPhotos->insertWidget(0, this->photosTopPanel);

    icon = QIcon::fromTheme("general_image", QIcon(":/res/general_image.png"));
    this->photosTopPanel->setPixmap(icon.pixmap(64, QIcon::Normal, QIcon::On));

    this->photosTopPanel->setRefreshIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    this->photosTopPanel->setBackIcon(QIcon::fromTheme("general_back", QIcon(":/res/general_back.png")));

    ui->listPhotos->setDragDropMode(QAbstractItemView::NoDragDrop);
    this->ui->listPhotos->setFont(this->usedFont);
    this->photosTopPanel->setFont(this->usedFont);

    //hideAll(ui->layoutPhotos);

    //signals
    connect(editOwnr, SIGNAL(textChanged(QString)), this, SLOT(editOwnr_textChanged(QString)));
    connect(buttonEditOwnr, SIGNAL(clicked()), this, SLOT(buttonResetOwnr_clicked()));
    connect(ui->listFriends, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(ownrSelected(QListWidgetItem*)));
    connect(ui->listFriends, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(ownrSelected(QListWidgetItem*)));
    connect(ui->listAlbums, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(albmSelected(QListWidgetItem*)));
    connect(ui->listPhotos, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(photoSelected(QListWidgetItem*)));
    connect(buttonRefreshFriends, SIGNAL(clicked()), this, SLOT(refreshFriends()));

    connect(this->albumsTopPanel, SIGNAL(refreshPressed()), this, SLOT(refreshAlbums()));
    connect(this->albumsTopPanel, SIGNAL(backPressed()), this, SLOT(hideAlbums()));
    connect(this->albumsTopPanel, SIGNAL(clicked()), this, SLOT(albumHeaderClicked()));

    connect(this->photosTopPanel, SIGNAL(refreshPressed()), this, SLOT(refreshPhotos()));
    connect(this->photosTopPanel, SIGNAL(backPressed()), this, SLOT(hidePhotos()));
    connect(this->photosTopPanel, SIGNAL(clicked()), this, SLOT(photoHeaderClicked()));

    // enable sorting
    this->ui->listAlbums->setSortingEnabled(true);
    //this->ui->listFriendsWidget->setSortingEnabled(true);

    // device rotation
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
}

void ImageBrowserPanel::buttonResetOwnr_clicked()
{
    editOwnr->clear();
}

void ImageBrowserPanel::editOwnr_textChanged(QString str)
{
    int num = ui->listFriends->count();
    if (str.count() > 0)
    {
        for (int i = 0; i < num; i++)
            if (ui->listFriends->item(i)->text().indexOf(str, 0, Qt::CaseInsensitive) < 0)
                ui->listFriends->item(i)->setHidden(TRUE);
            else
                ui->listFriends->item(i)->setHidden(FALSE);
    } else {
        for (int i = 0; i < num; i++)
            ui->listFriends->item(i)->setHidden(FALSE);
    }
    ui->listFriends->scrollTo(ui->listFriends->currentIndex());
}


void ImageBrowserPanel::addMeToFriends()
{
    bool isEnabledAccountFound = false;
    Friend myProfile;
    AccountList accs = this->sm->getAccounts();
    for (int i = 0; i < accs.length(); i++)
    {
        if (accs.at(i)->isNetworkEnabled)
        {
            myProfile = accs.at(i)->getProfile(false);
            isEnabledAccountFound = true;
            break;
        }
    }
    if (!isEnabledAccountFound && accs.length() > 0)
        myProfile = accs.at(0)->getProfile(false);

    qDebug() << __FILE__<<":" << __LINE__ << ": profile icon:" << myProfile.icon;
    QListWidgetItem *item = this->createFriendWidget(myProfile);
    ui->listFriends->insertItem(0, item);
}

QListWidgetItem * ImageBrowserPanel::createFriendWidget(Friend fr)
{
    QListWidgetItem *item = new QListWidgetItem(fr.name());
    QImage img = QImage(fr.icon);
    if (!img.isNull())
    {
        if (img.height() > img.width())
        {
            img = img.copy(0, (img.height() - img.width()) / 2, img.width(), img.width());
        }
        item->setIcon(QIcon(QPixmap::fromImage(img)));
    }
    if (item->icon().isNull())
        item->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));
    QVariant v;
    v.setValue(fr);
    item->setData(Qt::UserRole, v);

    return item;
}

void ImageBrowserPanel::ownrSelected(QListWidgetItem *item, bool isNeedUpdateState)
{
    qDebug() << item->text();
    this->setAlbumHeader();
    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Friend>()) {
        Friend fd = v.value<Friend>();
        qDebug() << "Get albums for " << fd.id;
        if (ui->listFriends->currentRow() == 0)
        {
            this->sm->getMyAlbums(false, true);
        } else {
            this->sm->getAlbums(fd, false, true);
        }
        this->setAlbumHeader(fd);

        if (isNeedUpdateState)
            this->setState(WindowAlbumFriend);
    }
}

void ImageBrowserPanel::ownrSelected(QListWidgetItem *item)
{
    this->ownrSelected(item, true);
}

void ImageBrowserPanel::albmSelected(QListWidgetItem *item)
{
    qDebug() << __FILE__ <<":"<< __LINE__ << ":"<< __FUNCTION__<< "(): Selected album name: " << item->text();
    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Album>()) {
        Album fd = v.value<Album>();
        qDebug() << "Get photos for " << fd.albumId;
        this->sm->getPhotos(fd, false, true);
        this->setPhotoHeader(fd);
    } else {
        this->setPhotoHeader();
    }
    this->setState(WindowPhotoAlbum);
}

QString ImageBrowserPanel::albumItem(Album al)
{
    QString str = Utils::decodeString(al.title) + "\n";
    str += tr("%1 photo(s)", "", al.size).arg(al.size) + ".\n";
    if (al.size != 0 && !al.time_update.isEmpty())
        str += tr(" Updated: ") + al.time_update;

    return str;
}

QPixmap ImageBrowserPanel::albumIcon(Album al)
{
    QPixmap pm(al.icon);
    if (pm.isNull())
    {
        QIcon icon = QIcon::fromTheme("tasklaunch_photos", QIcon(":/res/tasklaunch_photos.png"));
        pm = icon.pixmap(48, QIcon::Normal, QIcon::On);
    } else {
        pm = pm.scaledToWidth(80, Qt::SmoothTransformation);
    }
    return pm;
}

void ImageBrowserPanel::setAlbumHeader()
{
    this->albumsTopPanel->setText(tr("Album(s):"));
    this->albumsTopPanel->setPixmap(QIcon::fromTheme("tasklaunch_photos", QIcon(":/res/tasklaunch_photos.png")).pixmap(48, QIcon::Normal, QIcon::On));
}

void ImageBrowserPanel::setAlbumHeader(Friend fd)
{
    this->albumsTopPanel->setText(Utils::decodeString(fd.name()));
    QIcon friendIcon = QIcon(fd.icon);
    if (!friendIcon.isNull())
        this->albumsTopPanel->setPixmap(friendIcon.pixmap(48, QIcon::Normal, QIcon::On));
    else
        this->albumsTopPanel->setPixmap(QIcon::fromTheme("tasklaunch_photos", QIcon(":/res/tasklaunch_photos.png")).pixmap(48, QIcon::Normal, QIcon::On));
}

QPixmap ImageBrowserPanel::photoIcon(Photo al)
{
    QPixmap pm(al.icon);
    if (pm.isNull())
    {
        QIcon icon = QIcon::fromTheme("general_image", QIcon(":/res/general_image.png"));
        pm = icon.pixmap(48, QIcon::Normal, QIcon::On);
    } else {
        pm = pm.scaledToWidth(100, Qt::SmoothTransformation);
    }
    return pm;
}


void ImageBrowserPanel::setPhotoHeader()
{
    QIcon icon = QIcon::fromTheme("general_image", QIcon(":/res/general_image.png"));
    this->photosTopPanel->setPixmap(icon.pixmap(64, QIcon::Normal, QIcon::On));
    this->photosTopPanel->setText(tr("Photo(s):"));
}

void ImageBrowserPanel::setPhotoHeader(Album al)
{
    bool useDefaultIcon = false;
    this->photosTopPanel->setText(Utils::decodeString(al.title) +
                         (al.description.isNull() ? "": "\n" +
                          Utils::decodeString(al.description)) +
                         "\n" + tr("%1 photo(s):", "", al.size).arg(al.size));
    QPixmap *pm = new QPixmap(al.icon);
    if (pm->isNull())
    {
        useDefaultIcon = true;
    } else {
        *pm = pm->scaledToWidth(80, Qt::SmoothTransformation);
        QIcon albumIcon = QIcon(*pm);
        if (!albumIcon.isNull())
            this->photosTopPanel->setPixmap(albumIcon.pixmap(64, QIcon::Normal, QIcon::On));
        else
        {
            useDefaultIcon = true;
        }
    }
    if (useDefaultIcon)
    {
        QIcon icon = QIcon::fromTheme("general_image", QIcon(":/res/general_image.png"));
        this->photosTopPanel->setPixmap(icon.pixmap(64, QIcon::Normal, QIcon::On));
    }
}

void ImageBrowserPanel::photoSelected(QListWidgetItem *item) {
    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Photo>()) {
        Photo fd = v.value<Photo>();
        emit this->openImage(fd);
    }
}

void ImageBrowserPanel::updateListFriends(FriendList list, bool isLastUpdate)
{
    qDebug() << "Start update Friend list process. isLastUpdate=" << isLastUpdate;

    if (isLastUpdate) {
        this->isFriendsUpdate = false;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    } else {
        this->isFriendsUpdate = true;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
    }

    if (list.isEmpty())
    {
        this->ui->listFriends->clear();
        this->addMeToFriends();
        if (isLastUpdate)
        {
            new QListWidgetItem(tr("No Friends"), this->ui->listFriends);
        } else {
            new QListWidgetItem(tr("Download friend list"), this->ui->listFriends);
        }
        return;
    }

    if (this->ui->listFriends->count() == 0)
        this->addMeToFriends();

    FriendList newFriends(list);
    QList<QListWidgetItem *> dels;

    // check that all current friends is contains in new list
    for (int i = 1; i < ui->listFriends->count(); i++) {
        bool isFound = false;

        QListWidgetItem *item = ui->listFriends->item(i);

        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Friend>())
        {
            Friend oldFd = v.value<Friend>();

            //qDebug() << "Try to find friend with id " << oldFd.id << " from " << oldFd.accountId;
            int removedVal = -1;

            for (int j = 0; j < newFriends.length(); j++) {
                Friend curFd = newFriends.at(j);
                if (oldFd.id == curFd.id &&
                    oldFd.accountId == curFd.accountId) {
                    removedVal = j;
                    QImage *img = new QImage(curFd.icon);
                    if (img->height() > img->width())
                        *img = img->copy(0, (img->height() - img->width()) / 2, img->width(), img->width());
                    //item->setIcon(QIcon(curFd.icon));
                    item->setIcon(QIcon(QPixmap::fromImage(*img)));
                    if (item->icon().isNull())
                        item->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));
                    v.setValue(curFd);
                    item->setData(Qt::UserRole, v);

                    isFound = true;
                    delete img;
                    break;
                }
            }

            if (isFound && removedVal >= 0) {
                newFriends.removeAt(removedVal);
                //qDebug() << "found friend " << fd.id << "newFriends length: " << newFriends.length() << " all friends length " << list.length();
            } else {
                qDebug() << "prepare to remove friend with id " << oldFd.id << " from " << oldFd.accountId;
            }
        }

        if (!isFound)
            dels.append(item);
    }

    qDebug() << "Will be add " << newFriends.length() << " friends and removed " << dels.length() << " records. Total widgets: " << ui->listFriends->count();

    // del old friends
    for (int i = 0; i < dels.length(); i++) {
        if (dels.at(i)->isSelected()) {
            this->ui->listFriends->item(0)->setSelected(true);
            this->ownrSelected(this->ui->listFriends->item(0), false);
        }
        delete dels.at(i);
    }

    // add new Friends with asceding sorting
    for (int i = 0; i < newFriends.length(); i++)
    {
        //qDebug() << "added new Friend with id " << newFriends.at(i).id << " from " << newFriends.at(i).accountId;
        QListWidgetItem *item = createFriendWidget(newFriends.at(i));
        if (this->ui->listFriends->count() <= 1)
            this->ui->listFriends->addItem(item);

        bool flag = false;
        for (int j = 1; j < this->ui->listFriends->count(); j++)
        {
            if (this->ui->listFriends->item(j)->text().compare(item->text()) > 0)
            {
                this->ui->listFriends->insertItem(j, item);
                flag = true;
                break;
            }
        }
        if (!flag)
            this->ui->listFriends->addItem(item);
    }

    if (this->ui->listFriends->selectedItems().count() == 0)
    {
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): no selected items in friend list!";
        this->ui->listFriends->item(0)->setSelected(true);
        this->ui->listFriends->selectedItems().append(this->ui->listFriends->item(0));
        this->ownrSelected(this->ui->listFriends->item(0), false);
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): Selected me!!!";
    }

    // update album header for friend
    if (this->ui->listFriends->selectedItems().length() > 0)
    {
        QVariant v = this->ui->listFriends->selectedItems().at(0)->data(Qt::UserRole);
        Friend fd = v.value<Friend>();
        this->setAlbumHeader(fd);
    }
}

void ImageBrowserPanel::updateListAlbums(QString owner, AlbumList list, bool isLastUpdate)
{
    qDebug() << __FILE__ <<":"<<__LINE__<<":"<<__FUNCTION__<<"(): owner=" << owner << ";list.length()="<<list.length() << "; isLastUpdate=" << isLastUpdate;
    bool isFoundSelectedFriend = false;
    if (owner.isEmpty()) {
        // it's my cached albums. passed.
        isFoundSelectedFriend = true;
    }
    else {
        if (this->ui->listFriends->selectedItems().length() > 0)
        {
            // check correctness that list was return for selected friend
            QList<QListWidgetItem *> selFriends = ui->listFriends->selectedItems();
            for (int i = 0; i < selFriends.length(); i++) {
                QVariant v = selFriends[i]->data(Qt::UserRole);
                if (v.canConvert<Friend>()) {
                    Friend fd = v.value<Friend>();
                    if (owner == fd.id) {
                        isFoundSelectedFriend = true;
                        break;
                    }
                }
            }
        } else {
            // it is my albums
            AccountList accs = this->sm->getAccounts();
            for (int i = 0; i < accs.length(); i++)
            {
                if (accs.at(i)->getProfile(false).id == owner)
                {
                    isFoundSelectedFriend = true;
                    break;
                }
            }
        }
    }

    if (!isFoundSelectedFriend)
        return;

    qDebug() << __FILE__ <<":"<<__LINE__<<":"<<__FUNCTION__<<"(): check passed";
    if (isLastUpdate) {
        this->isAlbumsUpdate = false;
        this->albumsTopPanel->setRefreshIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    } else {
        this->isAlbumsUpdate = true;
        this->albumsTopPanel->setRefreshIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
    }

    if (list.isEmpty()) {
        qDebug() << "Empty album list for " << owner << "!!!!!!";
        ui->listAlbums->clear();
        if (isLastUpdate)
            new QListWidgetItem(tr("No albums"), ui->listAlbums); //QListWidgetItem *item2 = new
        else
            new QListWidgetItem(tr("Download albums"), this->ui->listAlbums);
        ui->listAlbums->setDisabled(true);
        return;
    }

    ui->listAlbums->setDisabled(false);
//    ui->listAlbums->setItemDelegate(new item(ui->listAlbums));

    QList<QListWidgetItem *> delItems;
    AlbumList newAlbums;
    newAlbums.append(list);

    // search new albums in list of widgets
    for (int i = 0; i < this->ui->listAlbums->count(); i++)
    {
        QListWidgetItem *item = this->ui->listAlbums->item(i);
        QVariant v = item->data(Qt::UserRole);

        bool isFound = false;
        int removedVal = -1;

        if (v.canConvert<Album>())
        {
            Album oldAlbum = v.value<Album>();

            //qDebug() << "Try to find friend with id " << oldFd.id << " from " << oldFd.accountId;

            for (int j = 0; j < newAlbums.length(); j++) {
                Album curAlbum = newAlbums.at(j);
                if (oldAlbum.albumId == curAlbum.albumId &&
                    oldAlbum.accountId == curAlbum.accountId) {
                    removedVal = j;
                    item->setData(Qt::DecorationRole, this->albumIcon(curAlbum));

                    item->setData(Qt::DisplayRole, this->albumItem(curAlbum));

                    qDebug() << __FILE__ << ":" << __LINE__ << ":" << "title=" << this->albumItem(curAlbum);

                    v.setValue(curAlbum);
                    item->setData(Qt::UserRole, v);

                    isFound = true;
                    break;
                }
            }

            if (isFound && removedVal >= 0) {
                newAlbums.removeAt(removedVal);
                //qDebug() << "found friend " << fd.id << "newFriends length: " << newFriends.length() << " all friends length " << list.length();
            } else {
                qDebug() << "prepare to remove album with id " << oldAlbum.albumId << " from " << oldAlbum.accountId;
            }
        }

        if (!isFound)
            delItems.append(item);
    }

    qDebug() << "Will be add " << newAlbums.length() << " albums and removed " << delItems.length() << " records. Total widgets: " << ui->listAlbums->count();

    // add new albums
    for (int i = 0; i < newAlbums.length(); i++) {
        //QListWidgetItem *item = new QListWidgetItem(str, ui->listAlbums);
        //item->setIcon(QIcon(list[i]->icon));
        //if (item->icon().isNull())
        //    item->setIcon(QPixmap(":/res/ms.png"));
        QListWidgetItem *albumitem = new QListWidgetItem(ui->listAlbums);
        albumitem->setData(Qt::DecorationRole, this->albumIcon(newAlbums.at(i)));

        albumitem->setData(Qt::DisplayRole, this->albumItem(newAlbums.at(i)));

        QVariant v;
        v.setValue(newAlbums[i]);
        albumitem->setData(Qt::UserRole, v);
    }

    // del old albums
    for (int i = 0; i < delItems.length(); i++) {
        if (delItems.at(i)->isSelected())
            this->hidePhotos();
        delete delItems.at(i);
    }

    // update photo header
    if (this->ui->listAlbums->selectedItems().length() > 0)
    {
        QVariant v = this->ui->listAlbums->selectedItems().at(0)->data(Qt::UserRole);
        Album al = v.value<Album>();
        this->setPhotoHeader(al);
    }
}

void ImageBrowserPanel::updateListPhotos(QString albumId, PhotoList list, bool isLastUpdate)
{
    // check correctness that list was return for selected photo list
    bool isFoundSelectedAlbum = false;
    QList<QListWidgetItem *> selItems = ui->listAlbums->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Album>()) {
            Album fd = v.value<Album>();
            if (albumId == fd.albumId) {
                isFoundSelectedAlbum = true;
                break;
            }
        }
    }
    if (!isFoundSelectedAlbum)
        return;

    if (isLastUpdate) {
        this->isPhotosUpdate = false;
        this->photosTopPanel->setRefreshIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    } else {
        this->isPhotosUpdate = true;
        this->photosTopPanel->setRefreshIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
    }

    if (list.isEmpty()) {
        this->ui->listPhotos->clear();
        if (isLastUpdate)
            new QListWidgetItem(tr("No images"), ui->listPhotos); //QListWidgetItem *item2 = new
        else
            new QListWidgetItem(tr("Download images"), this->ui->listPhotos);
        ui->listPhotos->setDisabled(true);
        return;
    }

    //ui->listPhotosWidget->clear();
    ui->listPhotos->setDisabled(false);


    QList<QListWidgetItem *> delItems;
    PhotoList newPhoto;
    newPhoto.append(list);

    // search new images in list of widgets
    for (int i = 0; i < this->ui->listPhotos->count(); i++)
    {
        QListWidgetItem *item = this->ui->listPhotos->item(i);
        QVariant v = item->data(Qt::UserRole);

        bool isFound = false;
        int removedVal = -1;

        if (v.canConvert<Photo>())
        {
            Photo oldPhoto = v.value<Photo>();

            //qDebug() << "Try to find friend with id " << oldFd.id << " from " << oldFd.accountId;

            for (int j = 0; j < newPhoto.length(); j++) {
                Photo curPhoto = newPhoto.at(j);
                if (oldPhoto.photoId == curPhoto.photoId &&
                    oldPhoto.accountId == curPhoto.accountId) {
                    removedVal = j;

                    QPixmap icon = this->photoIcon(curPhoto);
                    item->setData(Qt::DecorationRole, icon);
                    ((QAbstractItemView*)this->ui->listPhotos)->setIconSize(icon.size());

                    v.setValue(curPhoto);
                    item->setData(Qt::UserRole, v);

                    isFound = true;
                    break;
                }
            }

            if (isFound && removedVal >= 0) {
                newPhoto.removeAt(removedVal);
                //qDebug() << "found friend " << fd.id << "newFriends length: " << newFriends.length() << " all friends length " << list.length();
            } else {
                qDebug() << "prepare to remove photo with id " << oldPhoto.photoId << " from " << oldPhoto.accountId;
            }
        }

        if (!isFound)
            delItems.append(item);
    }
    this->ui->listPhotos->setUpdatesEnabled(false);
    // add new photos
    for (int i = 0; i < newPhoto.length(); i++) {
        qDebug() << "Show photo_thumb: " << newPhoto.at(i).photoId;
        QListWidgetItem *item = new QListWidgetItem(NULL, ui->listPhotos);
        QPixmap icon = this->photoIcon(newPhoto.at(i));
        item->setData(Qt::DecorationRole, icon);
        ((QAbstractItemView*)this->ui->listPhotos)->setIconSize(icon.size());
        QVariant v;
        v.setValue(newPhoto.at(i));
        item->setData(Qt::UserRole, v);
    }

    // del old photos
    for (int i = 0; i < delItems.length(); i++) {
        delete delItems.at(i);
    }

    this->ui->listPhotos->setUpdatesEnabled(true);
    this->ui->listPhotos->repaint();
}

void ImageBrowserPanel::albumHeaderClicked()
{

}

void ImageBrowserPanel::photoHeaderClicked()
{

}

void ImageBrowserPanel::refreshFriends()
{
    this->refreshFriends(true);
}

void ImageBrowserPanel::refreshFriends(bool isNeedUpdate)
{
    if (!this->isFriendsUpdate)
    {
        buttonResetOwnr_clicked();
        this->isFriendsUpdate = true;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
        sm->getFriends(isNeedUpdate, true);
    } else {
        //TODO: add stopping friends update
    }
}

void ImageBrowserPanel::refreshAlbums()
{
    this->refreshAlbums(true);
}

void ImageBrowserPanel::refreshAlbums(bool isNeedUpdate)
{
    qDebug() << __FILE__ <<":"<<__LINE__<<":"<<__FUNCTION__<<"(): isNeedUpdate=" << isNeedUpdate << "; albumUpdate=" << this->isAlbumsUpdate;

    if (!this->isAlbumsUpdate)
    {
//        this->isAlbumsUpdate = true;
//        buttonRefreshAlbums->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
        if (this->ui->listFriends->selectedItems().length() > 0)
        {
            QListWidgetItem *item = this->ui->listFriends->selectedItems().at(0);
            if (item != NULL)
            {
                qDebug() << "Update albums for " << item->text();
                QVariant v = item->data(Qt::UserRole);
                if (v.canConvert<Friend>()) {
                    Friend fd = v.value<Friend>();
                    qDebug() << "Get albums for " << fd.id;
                    this->sm->getAlbums(fd, isNeedUpdate, true);
                }
            }
        } else {
            qDebug("Try to load my albums");
            this->sm->getMyAlbums(isNeedUpdate, true);
        }
    } else {
        //TODO: add stopping albums update
    }
}

void ImageBrowserPanel::refreshPhotos()
{
    this->refreshPhotos(true);
}

void ImageBrowserPanel::refreshPhotos(bool isNeedUpdate)
{
    qDebug() << __FILE__ <<":"<< __LINE__ << ":" << __FUNCTION__<<"()";
    QListWidgetItem *item = this->ui->listAlbums->currentItem();
    if (item == NULL)
    {
        qWarning() << __FILE__ <<":"<< __LINE__ << ":" << "unknown selected item";
        return;
    }

    if (!this->isPhotosUpdate)
    {
        this->isPhotosUpdate = true;
        this->photosTopPanel->setRefreshIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
        qDebug() << "Update photos for " << item->text();
        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Album>()) {
            Album fd = v.value<Album>();
            qDebug() << "Get photos for " << fd.albumId;
            this->sm->getPhotos(fd, isNeedUpdate, true);
        }

    }
}

void ImageBrowserPanel::hidePhotos()
{
    this->setState(WindowAlbumPhoto);
}

void ImageBrowserPanel::hideAlbums()
{
    this->setState(WindowFriendAlbum);
}

void ImageBrowserPanel::hideAll(QLayout *layout)
{
    for (int i = 0; i < layout->count(); i++)
    {
        if(layout->itemAt(i)->layout())
        {
            hideAll(layout->itemAt(i)->layout());
        } else {
            layout->itemAt(i)->widget()->setVisible(FALSE);
        }
    }
}
void ImageBrowserPanel::showAll(QLayout *layout)
{
    for (int i = 0; i < layout->count(); i++)
    {
        if(layout->itemAt(i)->layout())
        {
            showAll(layout->itemAt(i)->layout());
        } else {
            layout->itemAt(i)->widget()->setVisible(TRUE);
        }
    }
}

void ImageBrowserPanel::setState()
{
    this->setState(this->state);
}

void ImageBrowserPanel::setState(WindowState state) {
    this->state = state;
    bool isMultiWindow = this->sm->settings->value(SETTINGS_MULTIPANEL).toBool() && !this->isPortraitMode;

    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): multiwindow=" << isMultiWindow;

    switch(this->state)
    {
    case WindowAlbumFriend:
        showAll(ui->layoutAlbums);
        hideAll(ui->layoutPhotos);
        if (isMultiWindow)
        {
            showAll(ui->layoutFriends);
        } else {
            hideAll(ui->layoutFriends);
        }
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): show albums from friends";
        break;
    case WindowAlbumPhoto: // from photo to album
        showAll(ui->layoutAlbums);
        hideAll(ui->layoutPhotos);
        if (isMultiWindow)
        {
            showAll(ui->layoutFriends);
        } else {
            hideAll(ui->layoutFriends);
        }
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): show albums from photos";
        break;
    case WindowFriendAlbum:
        showAll(ui->layoutFriends);
        hideAll(ui->layoutPhotos);
        if (isMultiWindow)
        {
            showAll(ui->layoutAlbums);
        } else {
            hideAll(ui->layoutAlbums);
        }
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): show friends";
        break;
    case WindowPhotoAlbum:
        hideAll(ui->layoutFriends);
        showAll(ui->layoutPhotos);
        if (isMultiWindow)
        {
            showAll(ui->layoutAlbums);
        } else {
            hideAll(ui->layoutAlbums);
        }
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): show photos";
        break;
    default:
        QMessageBox::warning(this, tr("Error occured"), tr("Unknown window state"));
        break;
    }
}

void ImageBrowserPanel::orientationChanged()
{
    QRect geom = QApplication::desktop()->screenGeometry();
    if (geom.width() > geom.height())
        this->isPortraitMode = false;
    else
        this->isPortraitMode = true;
    this->setState();
}
