#ifndef PHOTO_H
#define PHOTO_H

#include <QObject>
#include <QString>
#include <QImage>
#include <QTextCodec>
#include <QMetaType>
#include <QDomDocument>
#include <QFile>

class Photo;
typedef QList<Photo> PhotoList;

#include "photocomments.h"

#define FILE_PHOTO_COMMENTS_DATA "comments_%1_%2_%3.xml"
#define NODE_PHOTO_COMMENTS_ROOT "comments"

#define NODE_PHOTO_ROOT "photo"
#define NODE_PHOTO_ID "id"
#define NODE_PHOTO_CREATE "create"
#define NODE_PHOTO_IMAGE "image"
#define NODE_PHOTO_IMAGE_URL "image_url"
#define NODE_PHOTO_ICON "icon"
#define NODE_PHOTO_ICON_URL "icon_url"

class Photo : public QObject
{
    Q_OBJECT

public:
    Photo();
    Photo(const Photo& source);

    // photo ID from service
    QString photoId;

    // album ID from service
    QString albumId;

    // user ID from service
    QString ownerId;

    // creation time
    QString time_create;

    // path to thumbnail (icon)
    QString icon_url;

    // path to downloaded icon
    QString icon;

    // path to large image
    QString photo_url;

    // path to downloaded large image
    QString photo;

    // the name of account of this friend (not stored in cache)
    QString accountId;

    // store photolist data to XML format
    QDomElement toQDomElement(QDomDocument doc);

    // store photolist data to XML format
    static QDomElement toQDomElement(QDomDocument doc, Photo src);

    // load photolist from XML struct
    static Photo fromQDomElement(QDomElement fr, QString accountId, QString friendId, QString albumId);

    static void copyData(Photo *dst, const Photo *src);

    Photo& operator=(const Photo& source);

    // load photo comments from cache file.
    PhotoCommentList getPhotoComments();

    // set photo comments and store it to cache file.
    static void setPhotoComments(PhotoCommentList list, QString accountId, QString friendId, QString albumId, QString photoId);

};

Q_DECLARE_METATYPE(Photo)
//Q_DECLARE_METATYPE(Photo*)
Q_DECLARE_METATYPE(PhotoList)


#endif
