#ifndef MESSAGE_H
#define MESSAGE_H

#include <QObject>
#include <QString>
#include <QMetaType>
#include <QDomDocument>

#define NODE_MESSAGE_ROOT "message"
#define NODE_MESSAGE_ID "id"
#define NODE_MESSAGE_SENDER_ID "senderid"
#define NODE_MESSAGE_SENDER_NAME "sendername"
#define NODE_MESSAGE_RECEPIENT_ID "recepientid"
#define NODE_MESSAGE_RECEPIENT_NAME "recepientname"
#define NODE_MESSAGE_TEXT "text"
#define NODE_MESSAGE_TIME "time"
#define NODE_MESSAGE_TITLE "title"

class Message : public QObject
{
    Q_OBJECT
public:
    Message();
    Message(const Message&);
    ~Message();

    QString messageId;
    QString accountId;
    QString senderId;
    QString senderName;
//    QString recepientId;
//    QString recepientName;

    // message body
    QString text;

    // message title
    QString title;

    // date
    QString time;

    QString subject();
    QString subjectFromBody(QString messageBody);

    // store data to XML format
    QDomElement toQDomElement(QDomDocument doc);

    // store data to XML format
    static QDomElement toQDomElement(QDomDocument doc, Message src);

    // load message list from XML struct
    static Message fromQDomElement(QDomElement fr, QString accountId);

    Message& operator=(const Message&);
    static void copyData(Message *dst, const Message *src);

signals:

public slots:

};

typedef QList<Message> MessageList;

Q_DECLARE_METATYPE(Message)
Q_DECLARE_METATYPE(MessageList)

#endif // MESSAGE_H
