#ifndef FRIEND_H
#define FRIEND_H

#include <QObject>
#include <QString>
#include <QDomDocument>
#include <QFile>
#include <QDebug>
#include <QMetaType>

class Friend;

#include "album.h"
#include "utils/utils.h"

// the suffix of file with list of albums
#define FILE_ALBUMS_DATA "albums_%1.xml"
#define NODE_ALBUMS_ROOT "albums"


#define NODE_FRIEND_ROOT "friend"
#define NODE_FRIEND_ID "id"
#define NODE_FRIEND_FIRST_NAME "firstname"
#define NODE_FRIEND_NICK_NAME "nickname"
#define NODE_FRIEND_LAST_NAME "lastname"
#define NODE_FRIEND_ICON "icon"
#define NODE_FRIEND_ICON_URL "iconUrl"
#define NODE_FRIEND_GENDER "gender"
#define NODE_FRIEND_BIRTHDAY "birthday"
#define NODE_FRIEND_MOBILE_PHONE "mobilePhone"
#define NODE_FRIEND_HOME_PHONE "homePhone"
#define NODE_FRIEND_CITY "city"
#define NODE_FRIEND_COUNTRY "country"

#define FILE_OWNER_DATA "owner_%1.xml"

class Friend : public QObject
{
    Q_OBJECT

public:
    Friend();
    Friend(const Friend&);
    ~Friend();

    // friend ID from service
    QString id;

    // friend name
    QString firstName;

    QString nickName;

    QString lastName;

    // friend gender
    QString gender;

    // friend birthday
    QString birthday;

    // friend mobile phone number
    QString mobilePhone;

    // friend home phone number
    QString homePhone;

    // friend city
    QString city;

    // friend country
    QString country;

    // path to friend avatar image
    QString icon;

    // url of friend avatar image
    QString icon_url;

    // true if friend is online, otherwise false (not stored in cache)
    bool online;

    // the name of account of this friend (not stored in cache)
    QString accountId;

    QString name();

    // load album list from cache file.
    AlbumList getAlbumList();

    // set album list and store it to cache file.
    static void setAlbumList(AlbumList list, QString accountId, QString friendId);


    // store friends data to XML format
    static QDomElement toQDomElement(QDomDocument doc, Friend src);

    // load friend from XML struct
    static Friend fromQDomElement(QDomElement fr, QString accountId);

    Friend& operator=(const Friend&);

    static void copyData(Friend *dst, const Friend *src);

    void storeData();

    static Friend loadData(QString accountId, QString ownerId);
};

typedef QList<Friend> FriendList;

Q_DECLARE_METATYPE(Friend)
Q_DECLARE_METATYPE(FriendList)

#endif // FRIEND_H
