#include "soundcloud.h"
#include "feedurls.h"
#include "enums.h"
#include "utils.h"
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QUrl>
#include <QDebug>
#if QT_VERSION >= 0x050000
#include <QUrlQuery>
#endif

const QString CLIENT_ID("aada80a82c91fb42d0bb1cb321b59034");
const QString CLIENT_SECRET("dcc9c80ce05614d4988cebb82ddde152");
const QString REDIRECT_URI("http://www.musikloud.co.uk");

SoundCloud* soundCloudInstance = 0;

SoundCloud::SoundCloud(QObject *parent) :
    QObject(parent),
    m_nam(0)
{
    if (!soundCloudInstance) {
        soundCloudInstance = this;
    }
}

SoundCloud::~SoundCloud() {}

SoundCloud* SoundCloud::instance() {
    return soundCloudInstance;
}

QNetworkReply* SoundCloud::createReply(QUrl url, int offset) {
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);

    if (url.scheme() == "https") {
        if (this->userSignedIn()) {
            query.addQueryItem("oauth_token", this->accessToken());
        }
        else {
            url.setScheme("http");
            query.addQueryItem("client_id", CLIENT_ID);
        }
    }
    else {
        query.addQueryItem("client_id", CLIENT_ID);
    }

    if (offset) {
        query.addQueryItem("offset", QString::number(offset));
    }

    url.setQuery(query);
#else
    if (url.scheme() == "https") {
        if (this->userSignedIn()) {
            url.addQueryItem("oauth_token", this->accessToken());
        }
        else {
            url.setScheme("http");
            url.addQueryItem("client_id", CLIENT_ID);
        }
    }
    else {
        url.addQueryItem("client_id", CLIENT_ID);
    }

    if (offset) {
        url.addQueryItem("offset", QString::number(offset));
    }
#endif
    qDebug() << url;

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", QString("MusiKloud/%1 (Qt)").arg(Utils::versionNumberString()).toUtf8());

    return this->networkAccessManager()->get(request);
}

QNetworkReply* SoundCloud::createSearchReply(int queryType, const QString &query, int order, int offset) {
    QString qs(query);
    qs.replace(' ', '+');

    QUrl url;

    switch (queryType) {
    case Queries::Tracks:
        url = TRACKS_BASE_FEED;
        break;
    case Queries::Playlists:
        url = PLAYLISTS_BASE_FEED;
        break;
    case Queries::Users:
        url = USERS_BASE_FEED;
        break;
    case Queries::Groups:
        url = GROUPS_BASE_FEED;
        break;
    default:
        qWarning() << "SoundCloud::createSearchReply(): Invalid query type.";
        break;
    }
#if QT_VERSION >= 0x050000
    QUrlQuery urlQuery(url);

    switch (order) {
    case Queries::Date:
        urlQuery.addQueryItem("order", "created_at");
        break;
    default:
        urlQuery.addQueryItem("order", "hotness");
        break;
    }

    urlQuery.addQueryItem("q", "'" + query + "'|" + qs);
    urlQuery.addQueryItem("client_id", CLIENT_ID);

    if (offset) {
        urlQuery.addQueryItem("offset", QString::number(offset));
    }

    url.setQuery(urlQuery);
#else
    switch (order) {
    case Queries::Date:
        url.addQueryItem("order", "created_at");
        break;
    default:
        url.addQueryItem("order", "hotness");
        break;
    }

    url.addQueryItem("q", "'" + query + "'|" + qs);
    url.addQueryItem("client_id", CLIENT_ID);

    if (offset) {
        url.addQueryItem("offset", QString::number(offset));
    }
#endif
    qDebug() << url;

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", QString("MusiKloud/%1 (Qt)").arg(Utils::versionNumberString()).toUtf8());

    return this->networkAccessManager()->get(request);
}

QUrl SoundCloud::getStreamUrl(QUrl url) {
    if (url.scheme() == "https") {
        url.setScheme("http");
    }
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);

    if (!query.hasQueryItem("client_id")) {
        query.addQueryItem("client_id", CLIENT_ID);
    }

    url.setQuery(query);
#else
    if (!url.hasQueryItem("client_id")) {
        url.addQueryItem("client_id", CLIENT_ID);
    }
#endif
    return url;
}

QUrl SoundCloud::getDownloadUrl(QUrl url) {
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);

    if (url.scheme() == "https") {
        if (this->userSignedIn()) {
            query.addQueryItem("oauth_token", this->accessToken());
        }
        else {
            url.setScheme("http");
            query.addQueryItem("client_id", CLIENT_ID);
        }
    }
    else {
        query.addQueryItem("client_id", CLIENT_ID);
    }

    url.setQuery(query);
#else
    if (url.scheme() == "https") {
        if (this->userSignedIn()) {
            url.addQueryItem("oauth_token", this->accessToken());
        }
        else {
            url.setScheme("http");
            url.addQueryItem("client_id", CLIENT_ID);
        }
    }
    else {
        url.addQueryItem("client_id", CLIENT_ID);
    }
#endif
    return url;
}

void SoundCloud::setCredentials(const QString &user, const QString &token) {
    this->setUsername(user);
    this->setAccessToken(token);
}

void SoundCloud::setUsername(const QString &user) {
    m_username = user;
    emit usernameChanged();
}

void SoundCloud::setAccessToken(const QString &token) {
    m_accessToken = token;
    emit accessTokenChanged();
    emit userSignedInChanged(this->userSignedIn());
}
