#ifndef EVENTS_H
#define EVENTS_H

#include "event.h"
#include <QVariant>
#include <qplatformdefs.h>

class SoundCloud;
class QNetworkAccessManager;
class QDBusMessage;
class QDBusError;

class Events : public QObject
{
    Q_OBJECT

public:
    Events(QObject *parent = 0);
    ~Events() {}

public slots:
    bool enableSync();
    bool disableSync();
    void startSync();

private slots:
    void abortSync();
    void syncSuccess();
    void syncFailed();
    void getEvents();
    void processEvents();
#if (defined (MEEGO_EDITION_HARMATTAN)) || (defined (Q_WS_SAILFISH))
    void onThumbnailDownloaded();
#endif

private:
    void init();
    void addEvents();
#if (defined (MEEGO_EDITION_HARMATTAN)) || (defined (Q_WS_SAILFISH))
    QString base64SerializedVariant(const QVariant &value) const;
    void downloadThumbnails();
    void clearThumbnails();
#endif

private:
    QNetworkAccessManager *m_nam;
    SoundCloud *m_soundcloud;
    QList<Event> m_events;
    int m_index;
    bool m_initialized;
};

#endif  //  EVENTS_H
