#ifndef TRACKINFOWINDOW_H
#define TRACKINFOWINDOW_H

#include "stackedwindow.h"
#include "../base/trackitem.h"

class QLabel;
class SeparatorLabel;
class ThumbnailLabel;
class CommentListModel;
class ListView;
class ScrollArea;
class QAction;
class QModelIndex;

class TrackInfoWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit TrackInfoWindow(QSharedPointer<TrackItem> track, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void setMenuActions();

private slots:
    void playTrack();
    void queueTrack();
    void downloadTrack();
    void toggleFavourite();
    void showShareDialog();
    void showCommentDialog();
    void showUserChannel();
    void showUserChannel(const QModelIndex &index);
    void onFavouriteChanged(bool favourite);
    void onCommentsCountChanged(int count);
    void setThumbnails();
    
private:
    QSharedPointer<TrackItem> m_track;
    QAction *m_commentAction;
    QAction *m_favouritesAction;
    QAction *m_queueAction;
    QAction *m_downloadAction;
    QAction *m_shareAction;
    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    QLabel *m_genreLabel;
    QLabel *m_formatLabel;
    QLabel *m_sizeLabel;
    QLabel *m_lengthLabel;
    QLabel *m_playCountLabel;
    QLabel *m_downloadCountLabel;
    QLabel *m_descriptionLabel;
    ThumbnailLabel *m_thumbnailLabel;
    ThumbnailLabel *m_waveformLabel;
    SeparatorLabel *m_propertiesSeparator;
    SeparatorLabel *m_descriptionSeparator;
    SeparatorLabel *m_commentsSeparator;
    CommentListModel *m_commentsModel;
    ListView *m_commentsView;
    ScrollArea *m_scrollArea;
};

#endif // TRACKINFOWINDOW_H
