#ifndef PLAYLISTLISTTAB_H
#define PLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "../base/playlistitem.h"

class ListView;
class PlaylistListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class PlaylistListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit PlaylistListTab(QWidget *parent = 0);
    void setPlaylistFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    ListView *m_listView;
    PlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // PLAYLISTLISTTAB_H
