#ifndef HOMEWINDOW_H
#define HOMEWINDOW_H

#include "stackedwindow.h"
#include "../base/trackitem.h"
#include "../base/playlistitem.h"

class NavButton;
class NowPlayingButton;
class QGridLayout;
class QAction;

class HomeWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit HomeWindow(QWidget *parent = 0);

public slots:
    void search(const QString &query, Queries::QueryType type = Queries::Tracks, Queries::QueryOrder order = Queries::Hotness);
    void trackSearch(const QString &query, Queries::QueryOrder order = Queries::Hotness);
    void playlistSearch(const QString &query, Queries::QueryOrder order = Queries::Hotness);
    void groupSearch(const QString &query, Queries::QueryOrder order = Queries::Hotness);
    void userSearch(const QString &query);
    void showTrack(QSharedPointer<TrackItem> track);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);
    void showUserChannel(const QString &id);
    void playTrack(QSharedPointer<TrackItem> track);
    void displayTrack(const QStringList &urls);
    void displayTrack(const QString &url);
    void playTrack(const QStringList &urls);
    void playTrack(const QString &url);
    void displayPlaylist(const QStringList &urls);
    void displayPlaylist(const QString &url);
    void displayUser(const QStringList &urls);
    void displayUser(const QString &url);
    void displayResource(const QStringList &urls);
    void displayResource(const QString &url);

private slots:
    void showSettingsDialog();
    void showAboutDialog();
    void showAccountsDialog();
    void showMyChannel();
    void showActivities();
    void showExploreDialog();
    void showExploreWindow(Queries::QueryType type, const QString &title, const QUrl &feed);
    void showSearchDialog();
    void showPlaybackQueue();
    void showTransfers();
    void showArchive();
    void onResourceResolved(const QString &id, Queries::QueryType type);
    void onMediaPlayerChanged(const QString &mediaPlayer);

private:
    bool event(QEvent *event);
    void setLandscapeLayout();
    void setPortraitLayout();
    void showSignInDialog();

private:
    NavButton *m_myChannelButton;
    NavButton *m_activitiesButton;
    NavButton *m_exploreButton;
    NavButton *m_searchButton;
    NavButton *m_queueButton;
    NavButton *m_transfersButton;
    NavButton *m_archiveButton;
    NavButton *m_accountsButton;
    NavButton *m_settingsButton;
    NowPlayingButton *m_nowPlayingButton;
    QAction *m_settingsAction;
    QAction *m_aboutAction;
    QGridLayout *m_grid;
};

#endif // HOMEWINDOW_H
