#ifndef USERPROFILEWINDOW_H
#define USERPROFILEWINDOW_H

#include "../base/useritem.h"
#include <QWidget>
#include <QSharedPointer>

class SeparatorLabel;
class ThumbnailLabel;
class QScrollArea;
class QLabel;
class QPushButton;
class QGridLayout;

class UserProfileWindow : public QWidget
{
    Q_OBJECT

public:
    explicit UserProfileWindow(const QString &userId, QWidget *parent = 0);
    explicit UserProfileWindow(QSharedPointer<UserItem> user, QWidget *parent = 0);
    ~UserProfileWindow();

private slots:
    void setUser(QSharedPointer<UserItem> user);
    void setAvatar();
    void onProfileError();
    void toggleFollowing();
    void onFollowedChanged(bool followed);

private:
    QSharedPointer<UserItem> m_user;
    ThumbnailLabel *m_avatar;
    QLabel *m_channelLabel;
    QLabel *m_tracksLabel;
    QLabel *m_playlistsLabel;
    QLabel *m_followersLabel;
    QLabel *m_fullnameLabel;
    QLabel *m_locationLabel;
    QLabel *m_bandnameLabel;
    QLabel *m_websiteLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_noProfileLabel;
    QPushButton *m_followingButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // USERPROFILEWINDOW_H
