#ifndef USERLISTWINDOW_H
#define USERLISTWINDOW_H

#include <QWidget>

class QUrl;
class QListView;
class UserListModel;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class UserListWindow : public QWidget
{
    Q_OBJECT

public:
    explicit UserListWindow(QWidget *parent = 0);
    ~UserListWindow();

    void setUserFeed(const QUrl &feed);
    void search(const QString &query);

private slots:
    void onListItemActivated(const QModelIndex &index);

private:
    UserListModel *m_model;
    QListView *m_view;
    QVBoxLayout *m_vbox;
};

#endif // USERLISTWINDOW_H
