#ifndef SEARCHDIALOG_H
#define SEARCHDIALOG_H

#include "../base/enums.h"
#include <QDialog>

class QLineEdit;
class QComboBox;
class QDialogButtonBox;
class QGridLayout;
class SearchHistoryDialog;
class SearchListModel;

class SearchDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SearchDialog(QWidget *parent = 0);
    ~SearchDialog();

private slots:
    void onQueryChanged(const QString &query);
    void showHistoryDialog();
    void parseSearchQuery();

signals:
    void search(const QString &query, Queries::QueryType type, Queries::QueryOrder order);
    void fromUrl(const QString &url);
    
private:
    SearchListModel *m_historyModel;
    SearchHistoryDialog *m_historyDialog;
    QLineEdit *m_queryEdit;
    QComboBox *m_searchTypeComboBox;
    QComboBox *m_searchOrderComboBox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_cancelButton;
    QPushButton *m_historyButton;
    QPushButton *m_searchButton;
    QGridLayout *m_grid;
};

#endif // SEARCHDIALOG_H
