#include "searchdialog.h"
#include "searchhistorydialog.h"
#include "../base/searchlistmodel.h"
#include "../base/selectionmodels.h"
#include "../base/settings.h"
#include "../base/clipboardmonitor.h"
#include <QLineEdit>
#include <QLabel>
#include <QComboBox>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QGridLayout>

SearchDialog::SearchDialog(QWidget *parent) :
    QDialog(parent),
    m_historyModel(new SearchListModel(this)),
    m_historyDialog(0),
    m_queryEdit(new QLineEdit(this)),
    m_searchTypeComboBox(new QComboBox(this)),
    m_searchOrderComboBox(new QComboBox(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Horizontal, this)),
    m_cancelButton(m_buttonBox->addButton(QDialogButtonBox::Cancel)),
    m_historyButton(m_buttonBox->addButton(tr("History"), QDialogButtonBox::ActionRole)),
    m_searchButton(m_buttonBox->addButton(ClipboardMonitor::instance()->clipboardUrl().isEmpty() ? tr("Search") : tr("From URL"), QDialogButtonBox::AcceptRole)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Search"));
    this->setAttribute(Qt::WA_DeleteOnClose);

    m_searchTypeComboBox->setModel(new SearchTypeModel(m_searchTypeComboBox));
    m_searchTypeComboBox->setCurrentIndex(m_searchTypeComboBox->findData(Settings::instance()->searchType(), Qt::UserRole + 1));

    m_searchOrderComboBox->setModel(new SearchOrderModel(m_searchOrderComboBox));
    m_searchOrderComboBox->setCurrentIndex(m_searchOrderComboBox->findData(Settings::instance()->searchOrder(), Qt::UserRole + 1));

    m_grid->addWidget(new QLabel(tr("Query") + ":", this), 0, 0);
    m_grid->addWidget(m_queryEdit, 0, 1);
    m_grid->addWidget(new QLabel(tr("Search for") + ":", this), 1, 0);
    m_grid->addWidget(m_searchTypeComboBox, 1, 1);
    m_grid->addWidget(new QLabel(tr("Order by") + ":", this), 2, 0);
    m_grid->addWidget(m_searchOrderComboBox, 2, 1);
    m_grid->addWidget(m_buttonBox, 3, 0, 1, 2);

    this->connect(m_queryEdit, SIGNAL(textChanged(QString)), this, SLOT(onQueryChanged(QString)));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(parseSearchQuery()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
    this->connect(m_historyButton, SIGNAL(clicked()), this, SLOT(showHistoryDialog()));
}

SearchDialog::~SearchDialog() {}

void SearchDialog::onQueryChanged(const QString &query) {
    if ((query.isEmpty()) && (!ClipboardMonitor::instance()->clipboardUrl().isEmpty())) {
        m_searchButton->setText(tr("From URL"));
    }
    else {
        m_searchButton->setText(tr("Search"));
    }
}

void SearchDialog::showHistoryDialog() {
    if (!m_historyDialog) {
        m_historyDialog = new SearchHistoryDialog(m_historyModel, this);
        this->connect(m_historyDialog, SIGNAL(searchQueryChosen(QString)), m_queryEdit, SLOT(setText(QString)));
    }

    m_historyDialog->open();
}

void SearchDialog::parseSearchQuery() {
    if ((!ClipboardMonitor::instance()->clipboardUrl().isEmpty()) && (m_queryEdit->text().isEmpty())) {
        emit fromUrl(ClipboardMonitor::instance()->clipboardUrl());
    }
    else {
        Settings::instance()->setSearchType(static_cast<Queries::QueryType>(m_searchTypeComboBox->itemData(m_searchTypeComboBox->currentIndex(), Qt::UserRole + 1).toInt()));
        Settings::instance()->setSearchOrder(static_cast<Queries::QueryOrder>(m_searchOrderComboBox->itemData(m_searchOrderComboBox->currentIndex(), Qt::UserRole + 1).toInt()));

        m_historyModel->addSearch(m_queryEdit->text());

        emit search(m_queryEdit->text(), Settings::instance()->searchType(), Settings::instance()->searchOrder());

    }

    this->accept();
}
