#ifndef PLAYLISTTRACKSWINDOW_H
#define PLAYLISTTRACKSWINDOW_H

#include "../base/playlistitem.h"
#include <QWidget>
#include <QSharedPointer>

class TrackListModel;
class ThumbnailLabel;
class SeparatorLabel;
class QScrollArea;
class QListView;
class QLabel;
class QPushButton;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class PlaylistTracksWindow : public QWidget
{
    Q_OBJECT

public:
    explicit PlaylistTracksWindow(QSharedPointer<PlaylistItem> playlist, QWidget *parent = 0);
    ~PlaylistTracksWindow();

protected:
    void contextMenuEvent(QContextMenuEvent *event);

private slots:
    void setThumbnail();
    void setMenuActions();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void showUserChannel();
    void playPlaylist();
    void queuePlaylist();
    void downloadPlaylist();
    void onListItemActivated(const QModelIndex &index);
    void showTracksContextMenu(const QPoint &pos);
    void showSelectedTrack();
    void playSelectedTrack();
    void queueSelectedTrack();
    void downloadSelectedTrack();
    void addSelectedTrackToFavourites();

private:
    QSharedPointer<PlaylistItem> m_playlist;
    QMenu *m_contextMenu;
    QAction *m_playAction;
    QAction *m_queueAction;
    QAction *m_downloadAction;
    QMenu *m_tracksMenu;
    QAction *m_viewTrackAction;
    QAction *m_playTrackAction;
    QAction *m_queueTrackAction;
    QAction *m_downloadTrackAction;
    QAction *m_favouritesAction;
    QLabel *m_titleLabel;
    QLabel *m_descriptionLabel;
    QLabel *m_artistLabel;
    QLabel *m_dateLabel;
    ThumbnailLabel *m_thumbnail;
    QPushButton *m_playButton;
    SeparatorLabel *m_separator1;
    SeparatorLabel *m_separator2;
    QScrollArea *m_scrollArea;
    QListView *m_view;
    TrackListModel *m_model;
    QVBoxLayout *m_vbox;
};

#endif // PLAYLISTTRACKSWINDOW_H
