#ifndef NOWPLAYINGWINDOW_H
#define NOWPLAYINGWINDOW_H

#include <QWidget>

class NowPlayingListTab;
class NowPlayingCurrentTab;
class NowPlayingButton;
class QLabel;
class QStackedWidget;
class QGridLayout;
class QButtonGroup;

class NowPlayingWindow : public QWidget
{
    Q_OBJECT

public:
    explicit NowPlayingWindow(QWidget *parent = 0);
    ~NowPlayingWindow();

private slots:
    void onTabButtonClicked(int buttonId);
    void showListTab();
    void showNowPlayingTab();

private:
    NowPlayingListTab *m_listTab;
    NowPlayingCurrentTab *m_currentTab;
    NowPlayingButton *m_listButton;
    NowPlayingButton *m_currentButton;
    QButtonGroup *m_buttonGroup;
    QLabel *m_titleLabel;
    QStackedWidget *m_stack;
    QGridLayout *m_grid;
};

#endif // NOWPLAYINGWINDOW_H
