#ifndef NOWPLAYINGCURRENTTAB_H
#define NOWPLAYINGCURRENTTAB_H

#include "../base/trackitem.h"
#include <QWidget>
#include <QSharedPointer>

class QLabel;
class ThumbnailLabel;
class QMenu;
class QGridLayout;

class NowPlayingCurrentTab : public QWidget
{
    Q_OBJECT

public:
    explicit NowPlayingCurrentTab(QWidget *parent = 0);
    ~NowPlayingCurrentTab();

protected:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);
    void contextMenuEvent(QContextMenuEvent *event);

private:
    void connectPlaybackSignals();
    void disconnectPlaybackSignals();

private slots:
    void onCurrentTrackChanged(QSharedPointer<TrackItem> track);
    void onCurrentIndexChanged(int index);
    void onPlaybackQueueChanged(int count);
    void setThumbnail();
    void removeFromPlaybackQueue();

private:
    QLabel *m_trackCountLabel;
    QLabel *m_titleLabel;
    QLabel *m_artistLabel;
    ThumbnailLabel *m_thumbnail;
    QMenu *m_contextMenu;
    QAction *m_playPauseAction;
    QAction *m_removeAction;
    QAction *m_clearAction;
    QGridLayout *m_grid;
};

#endif // NOWPLAYINGCURRENTTAB_H
