#ifndef CHANNELWINDOW_H
#define CHANNELWINDOW_H

#include "../base/useritem.h"
#include <QWidget>
#include <QSharedPointer>

class UserProfileWindow;
class TrackListWindow;
class PlaylistListWindow;
class GroupListWindow;
class UserListWindow;
class QTabBar;
class QStackedWidget;
class QVBoxLayout;

class ChannelWindow : public QWidget
{
    Q_OBJECT

public:
    explicit ChannelWindow(const QString &userId, QWidget *parent = 0);
    explicit ChannelWindow(QSharedPointer<UserItem> user, QWidget *parent);
    ~ChannelWindow();

protected:
    void keyPressEvent(QKeyEvent *event);
    
private:
    void showProfile();
    void showTracks();
    void showFavourites();
    void showPlaylists();
    void showGroups();
    void showFollowings();

private slots:
    void onCurrentTabChanged(int index);

private:
    QString m_userId;
    UserProfileWindow *m_profileTab;
    TrackListWindow *m_tracksTab;
    TrackListWindow *m_favouritesTab;
    PlaylistListWindow *m_playlistsTab;
    GroupListWindow *m_groupsTab;
    UserListWindow *m_followingsTab;
    QTabBar *m_tabBar;
    QStackedWidget *m_stack;
    QVBoxLayout *m_vbox;
};

#endif // CHANNELWINDOW_H
