#include "archivewindow.h"
#include "archivetrackswindow.h"
#include "archiveplaylistswindow.h"
#include "tabbutton.h"
#include <QTabBar>
#include <QStackedWidget>
#include <QVBoxLayout>
#include <QKeyEvent>

ArchiveWindow::ArchiveWindow(QWidget *parent) :
    QWidget(parent),
    m_tracksTab(new ArchiveTracksWindow(this)),
    m_playlistsTab(0),
    m_tabBar(new QTabBar(this)),
    m_stack(new QStackedWidget(this)),
    m_vbox(new QVBoxLayout(this))
{
    this->setWindowTitle(tr("Archive"));

    m_tabBar->setDrawBase(false);
    m_tabBar->addTab(tr("Tracks"));
    m_tabBar->addTab(tr("Sets"));

    m_stack->addWidget(m_tracksTab);

    m_vbox->setContentsMargins(0, 0, 0, 0);
    m_vbox->setSpacing(0);
    m_vbox->addWidget(m_tabBar);
    m_vbox->addWidget(m_stack);

    this->connect(m_tabBar, SIGNAL(currentChanged(int)), this, SLOT(onCurrentTabChanged(int)));

    this->showTracks();
}

ArchiveWindow::~ArchiveWindow() {}

void ArchiveWindow::keyPressEvent(QKeyEvent *event) {
    switch (event->key()) {
    case Qt::Key_Left:
        m_tabBar->setCurrentIndex(m_tabBar->currentIndex() - 1);
        event->accept();
        return;
    case Qt::Key_Right:
        m_tabBar->setCurrentIndex(m_tabBar->currentIndex() + 1);
        event->accept();
        return;
    default:
        QWidget::keyPressEvent(event);
        return;
    }
}

void ArchiveWindow::showTracks() {
    m_stack->setCurrentWidget(m_tracksTab);
    m_tracksTab->setFocus(Qt::OtherFocusReason);
}

void ArchiveWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new ArchivePlaylistsWindow(this);
        m_stack->addWidget(m_playlistsTab);
    }

    m_stack->setCurrentWidget(m_playlistsTab);
    m_playlistsTab->setFocus(Qt::OtherFocusReason);
}

void ArchiveWindow::onCurrentTabChanged(int index) {
    switch (index) {
    case 1:
        this->showPlaylists();
        return;
    default:
        this->showTracks();
        return;
    }
}
