#ifndef ACTIVITYLISTWINDOW_H
#define ACTIVITYLISTWINDOW_H

#include "../base/trackitem.h"
#include "../base/playlistitem.h"
#include <QWidget>
#include <QSharedPointer>

class ActivityListModel;
class QListView;
class QModelIndex;
class QMenu;
class QVBoxLayout;

class ActivityListWindow : public QWidget
{
    Q_OBJECT

public:
    explicit ActivityListWindow(QWidget *parent = 0);
    ~ActivityListWindow();
    
private slots:
    void onListItemActivated(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void showSelectedItem();
    void playSelectedItem();
    void showTrack(QSharedPointer<TrackItem> track);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);
    void playTrack(QSharedPointer<TrackItem> track);

private:
    ActivityListModel *m_model;
    QListView *m_view;
    QMenu *m_contextMenu;
    QAction *m_viewAction;
    QAction *m_playAction;
    QAction *m_separatorAction;
    QAction *m_moreResultsAction;
    QVBoxLayout *m_vbox;
};

#endif // ACTIVITYLISTWINDOW_H
