#include "tracklauncher.h"
#include "settings.h"
#include <qplatformdefs.h>
#include <QTemporaryFile>
#include <QDir>
#include <QTimer>
#ifdef SYMBIAN_OS
#include <QDesktopServices>
#else
#include <QProcess>
#include <QDBusConnection>
#include <QDBusInterface>
#endif
#ifdef MEEGO_EDITION_HARMATTAN
#include <contentaction/contentaction.h>
#endif

TrackLauncher* TrackLauncher::self = 0;

TrackLauncher::TrackLauncher(QObject *parent) :
    QObject(parent)
{
    if (!self) {
        self = this;
    }
}

TrackLauncher::~TrackLauncher() {}

TrackLauncher* TrackLauncher::instance() {
    return !self ? new TrackLauncher : self;
}

void TrackLauncher::launchTrack(const QUrl &url) {
#ifdef MEDIA_PLAYERS_ENABLED
#ifdef SYMBIAN_OS
    QTemporaryFile *temp = new QTemporaryFile;
    temp->setFileName(QDir::tempPath() + "/musikloud.ram");

    if ((temp->open()) && (temp->write(QByteArray::fromPercentEncoding(url.toString().toUtf8())) > 0)) {
        QDesktopServices::openUrl(QUrl::fromLocalFile(temp->fileName()));
    }

    temp->close();
    QTimer::singleShot(5000, temp, SLOT(deleteLater()));
#else
    if (Settings::instance()->mediaPlayer() == "other") {
        QStringList args = Settings::instance()->mediaPlayerCommand().split(' ', QString::SkipEmptyParts);
        QProcess *player = new QProcess;
        QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start(args.takeFirst(), args << url.toString());
    }
#ifdef MEEGO_EDITION_HARMATTAN
    else if (Settings::instance()->mediaPlayer() == "mediaplayer") {
        ContentAction::Action::launcherAction("musicsuiteinterface.desktop", QStringList(url.toString())).trigger();
    }
    else if (Settings::instance()->mediaPlayer() == "kmplayer") {
        ContentAction::Action::launcherAction("kmplayer.desktop", QStringList(url.toString())).trigger();
    }
#endif
    else {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + Settings::instance()->mediaPlayer(), "/com/nokia/" + Settings::instance()->mediaPlayer(), "com.nokia." + Settings::instance()->mediaPlayer(), bus);
        dbus_iface.call("mime_open", url.toString());
    }
#endif
#else
    Q_UNUSED(url)

    qWarning() << "TrackLauncher::launchTrack(): External media players disabled";
#endif
}

void TrackLauncher::launchTracks(QList<QUrl> &urls) {
#ifdef MEDIA_PLAYERS_ENABLED
    QTemporaryFile *temp = new QTemporaryFile;
    temp->setFileName(QDir::tempPath() + "/musikloud.m3u");

    if (temp->open()) {
        while (!urls.isEmpty()) {
            temp->write(urls.takeFirst().toString().toUtf8() + '\n');
        }
#ifdef SYMBIAN_OS
        QDesktopServices::openUrl(QUrl::fromLocalFile(temp->fileName()));
#else
        if (Settings::instance()->mediaPlayer() == "other") {
            QStringList args = Settings::instance()->mediaPlayerCommand().split(' ', QString::SkipEmptyParts);
            QProcess *player = new QProcess;
            QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
            player->start(args.takeFirst(), args << temp->fileName());
        }
#ifdef MEEGO_EDITION_HARMATTAN
        else if (Settings::instance()->mediaPlayer() == "mediaplayer") {
            ContentAction::Action::launcherAction("musicsuiteinterface.desktop", QStringList(temp->fileName())).trigger();
        }
        else if (Settings::instance()->mediaPlayer() == "kmplayer") {
            ContentAction::Action::launcherAction("kmplayer.desktop", QStringList(temp->fileName())).trigger();
        }
#endif
        else {
            QDBusConnection bus = QDBusConnection::sessionBus();
            QDBusInterface dbus_iface("com.nokia." + Settings::instance()->mediaPlayer(), "/com/nokia/" + Settings::instance()->mediaPlayer(), "com.nokia." + Settings::instance()->mediaPlayer(), bus);
            dbus_iface.call("mime_open", temp->fileName());
        }
#endif
    }

    temp->close();
    QTimer::singleShot(5000, temp, SLOT(deleteLater()));
#else
    Q_UNUSED(urls)

    qWarning() << "TrackLauncher::launchTracks(): External media players disabled";
#endif
}
