#include "trackitem.h"
#include "utils.h"
#include "soundcloud.h"

TrackItem::TrackItem(QObject *parent) :
    QObject(parent),
    m_duration(0),
    m_trackNumber(1),
    m_size(0),
    m_playCount(0),
    m_lastPlayed(0),
    m_downloadCount(0),
    m_bpm(0),
    m_favourite(false),
    m_downloadable(false),
    m_downloaded(false),
    m_commentable(false),
    m_private(false),
    m_service(Services::NoService)
{
    this->connect(SoundCloud::instance(), SIGNAL(favouriteChanged(QString,bool)), this, SLOT(onFavouriteChanged(QString,bool)));
}

TrackItem::TrackItem(TrackItem *track, QObject *parent) :
    QObject(parent),
    m_id(track->id()),
    m_playlistId(track->playlistId()),
    m_url(track->url()),
    m_streamUrl(track->streamUrl()),
    m_downloadUrl(track->downloadUrl()),
    m_embedUrl(track->embedUrl()),
    m_title(track->title()),
    m_artist(track->artist()),
    m_artistId(track->artistId()),
    m_artistAvatarUrl(track->artistAvatarUrl()),
    m_description(track->description()),
    m_duration(track->duration()),
    m_date(track->date()),
    m_genre(track->genre()),
    m_trackNumber(track->trackNumber()),
    m_size(track->size()),
    m_tags(track->tags()),
    m_playCount(track->playCount()),
    m_lastPlayed(track->lastPlayed()),
    m_downloadCount(track->downloadCount()),
    m_format(track->format()),
    m_bpm(track->bpm()),
    m_thumbUrl(track->thumbnailUrl()),
    m_largeThumbUrl(track->largeThumbnailUrl()),
    m_waveformUrl(track->waveformUrl()),
    m_favourite(track->favourite()),
    m_downloadable(track->downloadable()),
    m_downloaded(track->downloaded()),
    m_commentable(track->commentable()),
    m_private(track->isPrivate()),
    m_service(track->service())
{
    this->connect(SoundCloud::instance(), SIGNAL(favouriteChanged(QString,bool)), this, SLOT(onFavouriteChanged(QString,bool)));
}

TrackItem::TrackItem(const QVariantMap &track, QObject *parent) :
    QObject(parent),
    m_id(track.value("id").toString()),
    m_url(track.value("url").toString()),
    m_streamUrl(track.value("streamable").toBool() ? track.value("stream_url").toString() : QString("http://api.soundcloud.com/tracks/%1/stream?client_id=376f225bf427445fc4bfb6b99b72e0bf").arg(this->id())),
    m_downloadUrl(track.value("download_url").toString()),
    m_embedUrl(track.value("embed_url").toString()),
    m_title(track.value("title").toString()),
    m_artist(track.value("user").toMap().value("username").toString()),
    m_artistId(track.value("user").toMap().value("id").toString()),
    m_artistAvatarUrl(track.value("user").toMap().value("avatar_url").toString()),
    m_description(track.value("description").toString().remove('\r')),
    m_duration(track.value("duration").toInt()),
    m_date(Utils::localDateTimeFromString(track.value("created_at").toString().section(' ', 0, 1))),
    m_genre(track.value("genre").toString()),
    m_trackNumber(0),
    m_size(track.value("original_content_size").toLongLong()),
    m_tags(track.value("tags").toStringList()),
    m_playCount(track.value("play_count").toInt()),
    m_lastPlayed(0),
    m_downloadCount(track.value("download_count").toInt()),
    m_format(track.value("original_format").toString()),
    m_bpm(track.value("bpm").toInt()),
    m_thumbUrl(track.value("artwork_url").toString()),
    m_largeThumbUrl(track.value("artwork_url").toString().section('-', 0, -2) + "-t500x500.jpg"),
    m_waveformUrl(track.value("waveform_url").toString()),
    m_favourite(track.value("user_favorite").toBool()),
    m_downloadable(track.value("downloadable").toBool()),
    m_downloaded(false),
    m_commentable(track.value("commentable").toBool()),
    m_private(track.value("sharing").toString() == "private"),
    m_service(Services::SoundCloud)
{
    this->connect(SoundCloud::instance(), SIGNAL(favouriteChanged(QString,bool)), this, SLOT(onFavouriteChanged(QString,bool)));
}

void TrackItem::loadTrack(TrackItem *track) {
    this->setId(track->id());
    this->setPlaylistId(track->playlistId());
    this->setUrl(track->url());
    this->setStreamUrl(track->streamUrl());
    this->setDownloadUrl(track->downloadUrl());
    this->setEmbedUrl(track->embedUrl());
    this->setTitle(track->title());
    this->setArtist(track->artist());
    this->setArtistId(track->artistId());
    this->setArtistAvatarUrl(track->artistAvatarUrl());
    this->setDescription(track->description());
    this->setDuration(track->duration());
    this->setDate(track->date());
    this->setGenre(track->genre());
    this->setTrackNumber(track->trackNumber());
    this->setSize(track->size());
    this->setTags(track->tags());
    this->setPlayCount(track->playCount());
    this->setLastPlayed(track->lastPlayed());
    this->setDownloadCount(track->downloadCount());
    this->setFormat(track->format());
    this->setBpm(track->bpm());
    this->setThumbnailUrl(track->thumbnailUrl());
    this->setLargeThumbnailUrl(track->largeThumbnailUrl());
    this->setWaveformUrl(track->waveformUrl());
    this->setFavourite(track->favourite());
    this->setDownloadable(track->downloadable());
    this->setDownloaded(track->downloaded());
    this->setCommentable(track->commentable());
    this->setPrivate(track->isPrivate());
    this->setService(track->service());
}

void TrackItem::onFavouriteChanged(const QString &id, bool favourite) {
    if (id == this->id()) {
        this->setFavourite(favourite);
    }
}
