#ifndef SETTINGS_H
#define SETTINGS_H

#include "enums.h"
#include <QSettings>
#include <QStringList>
#include <qplatformdefs.h>

class QNetworkProxy;
class QAuthenticator;

class Settings : public QSettings
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(bool scrobbleTracks
               READ scrobbleTracks
               WRITE setScrobbleTracks
               NOTIFY scrobbleTracksChanged)
    Q_PROPERTY(bool archiveOnline
               READ archiveOnline
               WRITE setArchiveOnline
               NOTIFY archiveOnlineChanged)
    Q_PROPERTY(AudioFormats::Format downloadFormat
               READ downloadFormat
               WRITE setDownloadFormat
               NOTIFY downloadFormatChanged)
    Q_PROPERTY(QString downloadPath
               READ downloadPath
               WRITE setDownloadPath
               NOTIFY downloadPathChanged)
    Q_PROPERTY(bool startTransfersAutomatically
               READ startTransfersAutomatically
               WRITE setStartTransfersAutomatically
               NOTIFY startTransfersAutomaticallyChanged)
    Q_PROPERTY(int maximumConcurrentTransfers
               READ maximumConcurrentTransfers
               WRITE setMaximumConcurrentTransfers
               NOTIFY maximumConcurrentTransfersChanged)
    Q_PROPERTY(bool createArtistSubfolders
               READ createArtistSubfolders
               WRITE setCreateArtistSubfolders
               NOTIFY createArtistSubfoldersChanged)
    Q_PROPERTY(Queries::QueryOrder searchOrder
               READ searchOrder
               WRITE setSearchOrder
               NOTIFY searchOrderChanged)
    Q_PROPERTY(Queries::QueryType searchType
               READ searchType
               WRITE setSearchType
               NOTIFY searchTypeChanged)
#if (defined (SYMBIAN_OS) || (defined (MEEGO_EDITION_HARMATTAN)))
    Q_PROPERTY(QString activeColor
               READ activeColor
           #ifdef SYMBIAN_OS
               CONSTANT)
#else
               WRITE setActiveColor
               NOTIFY activeColorChanged)
#endif
    Q_PROPERTY(QString activeColorString
               READ activeColorString
           #ifdef SYMBIAN_OS
               CONSTANT)
#else
               WRITE setActiveColorString
               NOTIFY activeColorStringChanged)
#endif
#endif
    Q_PROPERTY(QString language
               READ language
               WRITE setLanguage
               NOTIFY languageChanged)
#ifdef MEDIA_PLAYERS_ENABLED
    Q_PROPERTY(QString mediaPlayer
               READ mediaPlayer
               WRITE setMediaPlayer
               NOTIFY mediaPlayerChanged)
#ifndef SYMBIAN_OS
    Q_PROPERTY(QString mediaPlayerCommand
               READ mediaPlayerCommand
               WRITE setMediaPlayerCommand
               NOTIFY mediaPlayerCommandChanged)
#endif
#endif
#ifndef SYMBIAN_OS
    Q_PROPERTY(bool monitorClipboard
               READ monitorClipboard
               WRITE setMonitorClipboard
               NOTIFY monitorClipboardChanged)
#endif
    Q_PROPERTY(ScreenOrientation::Orientation screenOrientation
               READ screenOrientation
               WRITE setScreenOrientation
               NOTIFY screenOrientationChanged)
    Q_PROPERTY(NetworkProxyType::ProxyType networkProxyType
               READ networkProxyType
               WRITE setNetworkProxyType
               NOTIFY networkProxyTypeChanged)
    Q_PROPERTY(QString networkProxyHostName
               READ networkProxyHostName
               WRITE setNetworkProxyHostName
               NOTIFY networkProxyHostNameChanged)
    Q_PROPERTY(quint16 networkProxyPort
               READ networkProxyPort
               WRITE setNetworkProxyPort
               NOTIFY networkProxyPortChanged)
    Q_PROPERTY(QString networkProxyUser
               READ networkProxyUser
               WRITE setNetworkProxyUser
               NOTIFY networkProxyUserChanged)
    Q_PROPERTY(QString networkProxyPassword
               READ networkProxyPassword
               WRITE setNetworkProxyPassword
               NOTIFY networkProxyPasswordChanged)
#ifdef Q_WS_MAEMO_5
    Q_PROPERTY(bool eventFeedEnabled
               READ eventFeedEnabled
               WRITE setEventFeedEnabled
               NOTIFY eventFeedEnabledChanged)
    Q_PROPERTY(bool eventFeedInstalled
               READ eventFeedInstalled
               CONSTANT)
#endif
#ifdef IN_APP_UPDATES
    Q_PROPERTY(bool checkForUpdateOnStartup
               READ checkForUpdateOnStartup
               WRITE setCheckForUpdateOnStartup
               NOTIFY checkForUpdateOnStartupChanged)
#endif
#endif

public:
    explicit Settings(QObject *parent = 0);
    ~Settings();
    inline bool scrobbleTracks() const { return m_scrobble; }
    inline bool archiveOnline() const { return m_archiveOnline; }
    inline AudioFormats::Format downloadFormat() const { return m_downloadFormat; }
    inline bool startTransfersAutomatically() const { return m_autoTransfers; }
    inline int maximumConcurrentTransfers() const { return m_maxConcurrentTransfers; }
    inline QString downloadPath() const { return m_path; }
    inline bool createArtistSubfolders() const { return m_subfolders; }
    inline Queries::QueryOrder searchOrder() const { return m_searchOrder; }
    inline Queries::QueryType searchType() const { return m_searchType; }
#if (defined (SYMBIAN_OS) || (defined (MEEGO_EDITION_HARMATTAN)))
    inline QString activeColor() const { return m_activeColor; }
    inline QString activeColorString() const { return m_activeColorString; }
#endif
    inline QString language() const { return m_language; }
#ifdef MEDIA_PLAYERS_ENABLED
    inline QString mediaPlayer() const { return m_mediaplayer; }
#ifndef SYMBIAN_OS
    inline QString mediaPlayerCommand() const { return m_command; }
#endif
#endif
#ifndef SYMBIAN_OS
    inline bool monitorClipboard() const { return m_monitorClipboard; }
#endif
    inline ScreenOrientation::Orientation screenOrientation() const { return m_orientation; }
    inline NetworkProxyType::ProxyType networkProxyType() const { return m_proxyType; }
    inline QString networkProxyHostName() const { return m_proxyHost; }
    inline quint16 networkProxyPort() const { return m_proxyPort; }
    inline QString networkProxyUser() const { return m_proxyUser; }
    inline QString networkProxyPassword() const { return m_proxyPass; }
#ifdef Q_WS_MAEMO_5
    inline bool eventFeedEnabled() const { return m_eventFeedEnabled; }
    bool eventFeedInstalled() const;
#endif
#ifdef IN_APP_UPDATES
    inline bool checkForUpdateOnStartup() const { return m_checkUpdate; }
#endif

    static Settings* instance();

public slots:
    void saveSettings();
    void restoreSettings();
    void setScrobbleTracks(bool scrobble);
    void setArchiveOnline(bool online);
    void setDownloadFormat(AudioFormats::Format audioFormat);
    void setStartTransfersAutomatically(bool automatic);
    void setMaximumConcurrentTransfers(int maximum);
    void setDownloadPath(const QString &path);
    void setCreateArtistSubfolders(bool subfolders);
    void setSearchOrder(Queries::QueryOrder order);
    void setSearchType(Queries::QueryType type);
#ifdef MEEGO_EDITION_HARMATTAN
    void setActiveColor(const QString &color);
    void setActiveColorString(const QString &colorString);
#endif
    void setLanguage(const QString &lang);
#ifdef MEDIA_PLAYERS_ENABLED
    void setMediaPlayer(const QString &player);
#ifndef SYMBIAN_OS
    void setMediaPlayerCommand(const QString &command);
#endif
#endif
#ifndef SYMBIAN_OS
    void setMonitorClipboard(bool monitor);
#endif    
    void setScreenOrientation(ScreenOrientation::Orientation orientation);
    void setNetworkProxyType(NetworkProxyType::ProxyType proxyType);
    void setNetworkProxyHostName(const QString &hostName);
    void setNetworkProxyPort(quint16 port);
    void setNetworkProxyUser(const QString &user);
    void setNetworkProxyPassword(const QString &password);
    void setNetworkProxy();
#ifdef Q_WS_MAEMO_5
    void setEventFeedEnabled(bool enabled);
#endif
#ifdef IN_APP_UPDATES
    void setCheckForUpdateOnStartup(bool check);
#endif

private slots:
    void onNetworkProxyAuthenticationRequested(const QNetworkProxy &proxy, QAuthenticator *authenticator);

signals:
    void scrobbleTracksChanged(bool scrobble);
    void archiveOnlineChanged(bool online);
    void downloadFormatChanged(AudioFormats::Format audioFormat);
    void startTransfersAutomaticallyChanged(bool automatic);
    void maximumConcurrentTransfersChanged(int oldMaximum, int newMaximum);
    void downloadPathChanged(const QString &path);
    void createArtistSubfoldersChanged(bool subfolders);
    void searchOrderChanged(Queries::QueryOrder order);
    void searchTypeChanged(Queries::QueryType type);
#ifdef MEEGO_EDITION_HARMATTAN
    void activeColorChanged(const QString &color);
    void activeColorStringChanged(const QString &colorString);
#endif
    void languageChanged(const QString &language);
    void alert(const QString &message);
#ifdef MEDIA_PLAYERS_ENABLED
    void mediaPlayerChanged(const QString &player);
#ifndef SYMBIAN_OS
    void mediaPlayerCommandChanged(const QString &command);
#endif
#endif
#ifndef SYMBIAN_OS
    void monitorClipboardChanged(bool monitor);
#endif
    void screenOrientationChanged(ScreenOrientation::Orientation orientation);
    void networkProxyTypeChanged(NetworkProxyType::ProxyType proxyType);
    void networkProxyHostNameChanged(const QString &hostName);
    void networkProxyPortChanged(quint16 port);
    void networkProxyUserChanged(const QString &user);
    void networkProxyPasswordChanged(const QString &password);
#ifdef Q_WS_MAEMO_5
    void eventFeedEnabledChanged(bool enabled);
#endif
#ifdef IN_APP_UPDATES
    void checkForUpdateOnStartupChanged(bool check);
#endif

private:
    static Settings* self;
    bool m_scrobble;
    bool m_archiveOnline;
    AudioFormats::Format m_downloadFormat;
    bool m_autoTransfers;
    int m_maxConcurrentTransfers;
    QString m_path;
    bool m_subfolders;
    Queries::QueryOrder m_searchOrder;
    Queries::QueryType m_searchType;
#if (defined (SYMBIAN_OS) || (defined (MEEGO_EDITION_HARMATTAN)))
    QString m_activeColor;
    QString m_activeColorString;
#endif
    QString m_language;
#ifdef MEDIA_PLAYERS_ENABLED
    QString m_mediaplayer;
#ifndef SYMBIAN_OS
    QString m_command;
#endif
#endif
#ifndef SYMBIAN_OS
    bool m_monitorClipboard;
#endif
    ScreenOrientation::Orientation m_orientation;
    NetworkProxyType::ProxyType m_proxyType;
    QString m_proxyHost;
    quint16 m_proxyPort;
    QString m_proxyUser;
    QString m_proxyPass;
#ifdef Q_WS_MAEMO_5
    bool m_eventFeedEnabled;
    bool m_eventFeedInstalled;
#endif
#ifdef IN_APP_UPDATES
    bool m_checkUpdate;
#endif
};

#endif // SETTINGS_H
