#include "homescreenmodel.h"
#include <qplatformdefs.h>

HomescreenModel::HomescreenModel(QObject *parent) :
    QAbstractListModel(parent)
{
#if QT_VERSION >= 0x040600
    m_roleNames[NameRole] = "name";
    m_roleNames[IconSourceRole] = "iconSource";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif
#endif

#ifdef Q_WS_MAEMO_4
    m_list.append(QPair<QString, QString>(tr("You"), "/usr/share/icons/hicolor/64x64/hildon/qgn_addr_icon_avatar.png"));
    m_list.append(QPair<QString, QString>(tr("Dashboard"), "/usr/share/icons/hicolor/scalable/hildon/qgn_list_rss.png"));
    m_list.append(QPair<QString, QString>(tr("Explore"), "/usr/share/icons/hicolor/scalable/hildon/qgn_grid_tasknavigator_web.png"));
    m_list.append(QPair<QString, QString>(tr("Archive"), "/usr/share/icons/hicolor/scalable/hildon/qgn_list_filesys_audio_fldr.png"));
#else
    m_list.append(QPair<QString, QString>(tr("You"), "images/you.png"));
    m_list.append(QPair<QString, QString>(tr("Dashboard"), "images/dashboard.png"));
    m_list.append(QPair<QString, QString>(tr("Explore"), "images/explore.png"));
    m_list.append(QPair<QString, QString>(tr("Search"), "images/search.png"));
#ifndef Q_WS_SAILFISH
    m_list.append(QPair<QString, QString>(tr("Queue"), "images/queue.png"));
#endif
#ifndef MEEGO_EDITION_HARMATTAN
    m_list.append(QPair<QString, QString>(tr("Transfers"), "images/transfers.png"));
#endif
    m_list.append(QPair<QString, QString>(tr("Archive"), "images/archive.png"));
    m_list.append(QPair<QString, QString>(tr("Settings"), "images/settings.png"));
    m_list.append(QPair<QString, QString>(tr("Accounts"), "images/accounts.png"));
#if (defined (MEEGO_EDITION_HARMATTAN)) || (defined (Q_WS_SAILFISH))
    m_list.append(QPair<QString, QString>(tr("About"), "images/about.png"));
#endif
#endif
}

HomescreenModel::~HomescreenModel() {}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> HomescreenModel::roleNames() const {
    return m_roleNames;
}
#endif

int HomescreenModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant HomescreenModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case NameRole:
        return m_list.at(index.row()).first;
    case IconSourceRole:
        return m_list.at(index.row()).second;
    default:
        return QVariant();
    }
}

#if QT_VERSION >= 0x040600
QVariant HomescreenModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}
#endif
