#ifndef CONNECTIONLISTMODEL_H
#define CONNECTIONLISTMODEL_H

#include <QAbstractListModel>
#include <QStringList>

typedef struct {
    QString id;
    QString displayName;
    QString service;
    QString iconSource;
} Connection;

class ConnectionListModel : public QAbstractListModel
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(bool itemsSelected
               READ itemsSelected
               NOTIFY itemsSelectedChanged)
#endif

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        DisplayNameRole,
        ServiceRole,
        IconSourceRole,
        SelectedRole
    };

public:
    explicit ConnectionListModel(QObject *parent = 0);
    ~ConnectionListModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    inline bool loading() const { return m_loading; }
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#endif
    Q_INVOKABLE QList<int> selectedRows() const { return m_selectedRows; }
    inline bool itemsSelected() const { return !this->selectedRows().isEmpty(); }
    Q_INVOKABLE QStringList connections() const;
    Q_INVOKABLE QStringList connectionNames() const;

public slots:
    void clear();
    void reset();
    void getConnections();
    void toggleSelected(int row);

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }
    void appendConnection(Connection connection);

private slots:
    void addConnections();
    
signals:
    void countChanged(int count);
    void loadingChanged(bool loading);
    void itemsSelectedChanged(bool selected);
    
private:
    QList<Connection> m_list;
    bool m_loading;
    bool m_error;
    QList<int> m_selectedRows;
#if QT_VERSION >= 0x040600
    QHash<int, QByteArray> m_roleNames;
#endif
};

#endif // CONNECTIONLISTMODEL_H
