#ifndef COMMENTITEM_H
#define COMMENTITEM_H

#include "enums.h"
#include <QObject>
#include <QUrl>
#include <QVariantMap>
#include <QString>

class CommentItem : public QObject
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(QString id
               READ id
               CONSTANT)
    Q_PROPERTY(QString body
               READ body
               NOTIFY bodyChanged)
    Q_PROPERTY(QString artist
               READ artist
               NOTIFY artistChanged)
    Q_PROPERTY(QString artistId
               READ artistId
               NOTIFY artistIdChanged)
    Q_PROPERTY(QUrl artistAvatarUrl
               READ artistAvatarUrl
               NOTIFY artistAvatarUrlChanged)
    Q_PROPERTY(QString date
               READ date
               NOTIFY dateChanged)
    Q_PROPERTY(qint64 timestamp
               READ timestamp
               CONSTANT)
    Q_PROPERTY(QString trackId
               READ trackId
               NOTIFY trackIdChanged)
    Q_PROPERTY(Services::AudioService service
               READ service
               NOTIFY serviceChanged)
#endif

public:
    explicit CommentItem(QObject *parent = 0);
    explicit CommentItem(CommentItem *comment, QObject *parent = 0);
    explicit CommentItem(const QVariantMap &comment, QObject *parent = 0);
    ~CommentItem() {}
    Q_INVOKABLE void loadComment(CommentItem *comment);
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString body() const { return m_body; }
    inline void setBody(const QString &body) { m_body = body; emit bodyChanged(body); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; emit artistChanged(artist); }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; emit artistIdChanged(id); }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; emit artistAvatarUrlChanged(url);}
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; emit dateChanged(date); }
    inline qint64 timestamp() const { return m_timestamp; }
    inline void setTimestamp(qint64 timestamp) { m_timestamp = timestamp; }
    inline QString trackId() const { return m_trackId; }
    inline void setTrackId(const QString &id) { m_trackId = id; emit trackIdChanged(id); }
    inline int indent() const { return m_indent; }
    inline void setIndent(int indent) { m_indent = indent; emit indentChanged(indent); }
    inline bool loading() const { return m_loading; }
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline Services::AudioService service() const { return m_service; }
    inline void setService(Services::AudioService service) { m_service = service; emit serviceChanged(service); }
    inline bool operator ==(CommentItem *other) { return other->id() == this->id(); }

signals:
    void bodyChanged(const QString &body);
    void artistChanged(const QString &artist);
    void artistIdChanged(const QString &id);
    void artistAvatarUrlChanged(const QUrl &url);
    void dateChanged(const QString &date);
    void trackIdChanged(const QString &replyId);
    void indentChanged(int indent);
    void loadingChanged(bool loading);
    void serviceChanged(Services::AudioService service);

private:
    QString m_id;
    QString m_body;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_date;
    qint64 m_timestamp;
    QString m_trackId;
    int m_indent;
    bool m_loading;
    Services::AudioService m_service;
};

#endif // COMMENTITEM_H
