#ifndef MEDIAPLAYER_H
#define MEDIAPLAYER_H

#include "../../base/trackitem.h"
#include <phonon>
#include <QSharedPointer>
#include <qplatformdefs.h>
#ifdef MEEGO_EDITION_HARMATTAN
#include <resource/qt4/policy/resource-set.h>
#endif

class MediaPlayer : public QObject
{
    Q_OBJECT

#if QT_VERSION >= 0x040700
    Q_PROPERTY(bool playing
               READ playing
               NOTIFY stateChanged)
    Q_PROPERTY(bool paused
               READ paused
               NOTIFY stateChanged)
    Q_PROPERTY(qint64 position
               READ position
               WRITE setPosition
               NOTIFY positionChanged)
    Q_PROPERTY(qint64 duration
               READ duration
               NOTIFY durationChanged)
    Q_PROPERTY(qreal volume
               READ volume
               WRITE setVolume
               NOTIFY volumeChanged)
    Q_PROPERTY(bool muted
               READ muted
               WRITE setMuted
               NOTIFY mutedChanged)
    Q_PROPERTY(PlaybackMode::Mode playbackMode
               READ playbackMode
               WRITE setPlaybackMode
               NOTIFY playbackModeChanged)
    Q_PROPERTY(int currentIndex
               READ currentIndex
               WRITE setCurrentIndex
               NOTIFY currentIndexChanged)
#ifdef QML_USER_INTERFACE
    Q_PROPERTY(TrackItem* currentTrack
               READ currentTrackFromQML
               NOTIFY currentTrackChanged)
#else
    Q_PROPERTY(QSharedPointer<TrackItem> currentTrack
               READ currentTrack
               NOTIFY currentTrackChanged)
#endif
#endif

public:
    explicit MediaPlayer(QObject *parent = 0);
    ~MediaPlayer();
    Phonon::MediaObject* mediaObject() const;
    Phonon::AudioOutput* audioOutput() const;
#ifdef QML_USER_INTERFACE
    inline TrackItem* currentTrackFromQML() const { return m_track.data(); }
#endif
    inline QSharedPointer<TrackItem> currentTrack() const { return m_track; }
    inline int currentIndex() const { return m_index; }
    inline PlaybackMode::Mode playbackMode() const { return m_playbackMode; }
    bool playing() const;
    bool paused() const;
    qint64 position() const;
    qint64 duration() const;
    qreal volume() const;
    bool muted() const;
    Phonon::State state() const;

    static MediaPlayer* instance();
        
public slots:
#ifdef QML_USER_INTERFACE
    void playTrack(TrackItem *track, bool playImmediately = true);
    void playTracks(QList<TrackItem*> tracks, bool playImmediately = true);
#else
    void playTrack(QSharedPointer<TrackItem> track, bool playImmediately = true);
    void playTracks(QList< QSharedPointer<TrackItem> > tracks, bool playImmediately = true);
#endif
    void removeTrack(int row);
    void clearTracks();
    void setPlaybackMode(PlaybackMode::Mode mode);
    void setSequentialPlaybackMode();
    void setRepeatAllPlaybackMode();
    void setRepeatOnePlaybackMode();
    void togglePlaybackMode();
    void togglePlayPause();
    void play(bool resetSource = false);
    void pause();
    void stop();
    void next();
    void previous();
    void setCurrentIndex(int index, bool playImmediately = true);
    void setPosition(qint64 position);
    void setVolume(qreal volume);
    void setMuted(bool muted);
    void toggleMuted();
    void startTick();
    void stopTick();

private:
    void setCurrentTrack(QSharedPointer<TrackItem> track);
    void onTrackPlayed(QSharedPointer<TrackItem> track);

private slots:
    void onStateChanged(Phonon::State state);
    void onPlaybackFinished();
    void onError(const QString &errorString);
#ifdef MEDIA_PLAYERS_ENABLED
    void onMediaPlayerChanged(const QString &mediaPlayer);
#endif
    void onCountChanged(int count);
#ifdef MEEGO_EDITION_HARMATTAN
    void onResourcesGranted();
    void onResourcesReleased();
    void onResourcesDenied();
    void onResourcesLost();
#endif

signals:
#ifdef QML_USER_INTERFACE
    void currentTrackChanged(TrackItem *track);
#else
    void currentTrackChanged(QSharedPointer<TrackItem> track);
#endif
    void currentIndexChanged(int index);
    void playbackModeChanged(PlaybackMode::Mode mode);
    void positionChanged(qint64 position);
    void durationChanged(qint64 duration);
    void volumeChanged(qreal volume);
    void mutedChanged(bool muted);
    void stateChanged(Phonon::State state);

private:
    static MediaPlayer* m_instance;
    Phonon::MediaObject *m_mediaPlayer;
    Phonon::AudioOutput *m_audioOutput;
    QSharedPointer<TrackItem> m_track;
    int m_index;
    PlaybackMode::Mode m_playbackMode;
#ifdef MEEGO_EDITION_HARMATTAN
    ResourcePolicy::ResourceSet *m_resourceSet;
    ResourcePolicy::AudioResource *m_audioResource;
#endif
};

#endif // MEDIAPLAYER_H
