#include "sharingdialog.h"
#include "connectionsdialog.h"
#include "../base/soundcloud.h"
#include <QPlainTextEdit>
#include <QMaemo5ValueButton>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QLabel>

SharingDialog::SharingDialog(QSharedPointer<TrackItem> track, QWidget *parent) :
    AbstractDialog(parent),
    m_track(track),
    m_messageEdit(new QPlainTextEdit(this)),
    m_connectionsSelector(new QMaemo5ValueButton(tr("Connections"))),
    m_connectionsDialog(0),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical)),
    m_button(m_buttonBox->addButton(QDialogButtonBox::Ok)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Share track"));

    m_button->setEnabled(false);
    m_connectionsSelector->setValueText(tr("None"));

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(shareTrack()));
    this->connect(m_messageEdit, SIGNAL(textChanged()), this, SLOT(onMessageChanged()));
    this->connect(m_connectionsSelector, SIGNAL(clicked()), this, SLOT(showConnectionsDialog()));

    this->onOrientationChanged();
}

void SharingDialog::setLandscapeLayout() {
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(new QLabel(tr("Message"), this), 0, 0);
        m_grid->addWidget(m_messageEdit, 1, 0);
        m_grid->addWidget(m_connectionsSelector, 2, 0);
        m_grid->addWidget(m_buttonBox, 2, 1);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 2, 1);
    }

    this->setFixedHeight(340);
}

void SharingDialog::setPortraitLayout() {
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(new QLabel(tr("Message"), this), 0, 0);
        m_grid->addWidget(m_messageEdit, 1, 0);
        m_grid->addWidget(m_connectionsSelector, 2, 0);
        m_grid->addWidget(m_buttonBox, 2, 1);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 3, 0);
    }

    this->setFixedHeight(600);
}

void SharingDialog::onMessageChanged() {
    m_button->setEnabled((!m_messageEdit->toPlainText().isEmpty()) && ((m_connectionsDialog) && (!m_connectionsDialog->connections().isEmpty())));
}

void SharingDialog::onConnectionNamesChanged(const QStringList &names) {
    m_connectionsSelector->setValueText(names.isEmpty() ? tr("None") : names.join(", "));
    m_button->setEnabled((!m_messageEdit->toPlainText().isEmpty()) && (!names.isEmpty()));
}

void SharingDialog::showConnectionsDialog() {
    if (!m_connectionsDialog) {
        m_connectionsDialog = new ConnectionsDialog(this);
        this->connect(m_connectionsDialog, SIGNAL(connectionNamesChanged(QStringList)), this, SLOT(onConnectionNamesChanged(QStringList)));
    }

    m_connectionsDialog->open();
}

void SharingDialog::shareTrack() {
    SoundCloud::instance()->shareTrack(m_track.data()->id(), m_connectionsDialog->connections(), m_messageEdit->toPlainText());
    this->accept();
}
