#include "nowplayingwindow.h"
#include "nowplayingmediatab.h"
#include "nowplayinginfotab.h"
#include "../base/playbacklistmodel.h"
#include <QStackedWidget>
#include <QMenu>
#include <QMenuBar>
#include <QActionGroup>

NowPlayingWindow::NowPlayingWindow(QWidget *parent) :
    StackedWindow(parent),
    m_menu(this->menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_mediaAction(new QAction(tr("Media"), this)),
    m_infoAction(new QAction(tr("Info"), this)),
    m_stack(new QStackedWidget(this)),
    m_mediaTab(new NowPlayingMediaTab(this)),
    m_infoTab(0)
{
    this->setWindowTitle(tr("Now playing"));
    this->setCentralWidget(m_stack);

    m_mediaAction->setCheckable(true);
    m_mediaAction->setActionGroup(m_actionGroup);
    m_infoAction->setCheckable(true);
    m_infoAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_mediaAction);
    m_menu->addAction(m_infoAction);

    m_mediaAction->setChecked(true);

    m_stack->setFrameStyle(QFrame::NoFrame);
    m_stack->addWidget(m_mediaTab);

    this->connect(m_mediaAction, SIGNAL(triggered()), this, SLOT(showMediaTab()));
    this->connect(m_infoAction, SIGNAL(triggered()), this, SLOT(showInfoTab()));
    this->connect(PlaybackListModel::playbackQueue(), SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));

    this->showMediaTab();
}

void NowPlayingWindow::clearMenuActions() {
    QList<QAction*> actions = this->menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        this->menuBar()->removeAction(actions.at(i));
    }
}

void NowPlayingWindow::showMediaTab() {
    m_stack->setCurrentWidget(m_mediaTab);
    this->clearMenuActions();
    this->menuBar()->addActions(m_mediaTab->actions());
}

void NowPlayingWindow::showInfoTab() {
    if (!m_infoTab) {
        m_infoTab = new NowPlayingInfoTab(this);
        m_stack->addWidget(m_infoTab);
    }

    m_stack->setCurrentWidget(m_infoTab);
    this->clearMenuActions();
    this->menuBar()->addActions(m_infoTab->actions());
}

void NowPlayingWindow::onCountChanged(int count) {
    if (count == 0) {
        this->close();
    }
}
