#ifndef ARCHIVEWINDOW_H
#define ARCHIVEWINDOW_H

#include "stackedwindow.h"

class ArchiveTracksTab;
class ArchivePlaylistsTab;
class QStackedWidget;
class QActionGroup;
class QAction;
class QMenu;

class ArchiveWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit ArchiveWindow(QWidget *parent = 0);

private slots:
    void showTracks();
    void showPlaylists();
    void clearMenuActions();
    
private:
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_tracksAction;
    QAction *m_playlistsAction;
    ArchiveTracksTab *m_tracksTab;
    ArchivePlaylistsTab *m_playlistsTab;
    QStackedWidget *m_stack;
};

#endif // ARCHIVEWINDOW_H
